//
//  APMSDK.h
//  APMSDK
//
//  Created by APM on 2023/5/19.
//
//

#import <Foundation/Foundation.h>
#import <APMSDK/APMURLProtocol.h>

NS_ASSUME_NONNULL_BEGIN

@interface APMSDK : NSObject

/**
 启动 SDK：加载mainBundle中的配置文件apm-sdk-config.json.
 @return 成功返回YES，失败返回NO.
 */
+ (BOOL)start;

 /**
 添加自定义事件.
 
 @param key 事件名称.
 @param value 事件内容，NSString，NSArray，NSDictionary等有效的JSON对象.
 @return 成功返回YES，失败返回NO.
 */
+ (BOOL)event:(NSString *)key value:(id)value;

/**
 设置自定义ID.

@param uid 自定义ID.
@return 成功返回YES，失败返回NO.
*/
+ (BOOL)setUid:(NSString *_Nullable)uid;

/**
添加自定义标签.

@param tag 自定义标签，多个tag使用英文逗号隔开.
@return 成功返回YES，失败返回NO.
*/
+ (BOOL)addTag:(NSString *)tag;

@end

NS_ASSUME_NONNULL_END
