//
//  APMURLProtocol.h
//  APMSDK
//
//  Created by APM on 2023/10/23.
//
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class APMURLProtocol;

@protocol APMURLProtocolDelegate <NSObject>

@optional
/**
是否处理身份认证质询。

@param protocol URLProtocol子类对象。
@param protectionSpace 保护空间。
@return 返回YES：将回调APMURLProtocol:didReceiveAuthenticationChallenge代理方法进一步处理认证质询；返回NO：将采用默认方式处理。
*/
- (BOOL)APMURLProtocol:(APMURLProtocol *)protocol canAuthenticateAgainstProtectionSpace:(NSURLProtectionSpace *)protectionSpace;

/**
处理身份认证质询：生成NSURLCredential对象后，需调用[APMURLProtocol resolveAuthenticationChallenge:withCredential]完成认证质询。

@param protocol URLProtocol子类实例对象。
@param challenge 身份认证挑战对象。
*/
- (void)APMURLProtocol:(APMURLProtocol *)protocol didReceiveAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge;

/**
已取消身份认证质询的回调函数。

@param protocol URLProtocol子类实例对象。
@param challenge 身份认证挑战对象。
*/
- (void)APMURLProtocol:(APMURLProtocol *)protocol didCancelAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge;

@end

@interface APMURLProtocol : NSURLProtocol

/**
设置网络请求身份认证质询代理对象。

@param delegate 遵循APMURLProtocolDelegate协议的代理对象。
*/
+ (void)setDelegate:(id<APMURLProtocolDelegate> _Nullable)delegate;

/**
 当代理在[APMURLProtocol:didReceiveAuthenticationChallenge]中创建凭证后，调用该函数告知SDK进行下一步处理。

@param challenge 身份认证挑战对象。
@param credential 凭证对象。
*/
- (void)resolveAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge withCredential:(NSURLCredential *_Nullable)credential;

@end


NS_ASSUME_NONNULL_END
