/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin;

import com.android.build.gradle.AppExtension;
import com.cloud.apm.plugin.tasks.construct.ConstructService;
import com.cloud.apm.plugin.tasks.trace.TraceService;
import com.cloud.apm.plugin.tasks.traffic.TrafficService;
import com.cloud.apm.plugin.utils.APMPluginErrorException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/cloud/apm/plugin/APMPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "Companion", "apm-plugin"})
public final class APMPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TAG = "APM-Plugin";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        System.out.println((Object)"APMPlugin-2.0.23-223 apply start!");
        if (!project.getPlugins().hasPlugin("com.android.application")) {
            throw new APMPluginErrorException("Android Application plugin is required.");
        }
        Object object = project.getExtensions().getByName("android");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.AppExtension");
        }
        AppExtension appExtension = (AppExtension)object;
        new ConstructService().inject(appExtension, project);
        new TrafficService().inject(appExtension, project);
        new TraceService().inject(appExtension, project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cloud/apm/plugin/APMPlugin$Companion;", "", "()V", "TAG", "", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

