/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace.mapping;

import com.cloud.apm.plugin.tasks.trace.mapping.IMappingHandler;
import com.cloud.apm.plugin.tasks.trace.methodTrace.MethodInfo;
import com.cloud.apm.plugin.utils.PluginLog;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 42\u00020\u0001:\u000245B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J8\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u001e\u0010!\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005J\u0016\u0010#\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J \u0010(\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0017H\u0002J\u0016\u0010&\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J\u0016\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005J\n\u00103\u001a\u00020\u0005*\u00020\u0005R,\u0010\u0003\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR,\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR6\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u000e\u00a8\u00066"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector;", "Lcom/cloud/apm/plugin/tasks/trace/mapping/IMappingHandler;", "()V", "obfuscatedClassMethodMap", "", "", "", "Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodInfo;", "obfuscatedRawClassMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getObfuscatedRawClassMap", "()Ljava/util/HashMap;", "setObfuscatedRawClassMap", "(Ljava/util/HashMap;)V", "originalClassMethodMap", "rawObfuscatedClassMap", "getRawObfuscatedClassMap", "setRawObfuscatedClassMap", "rawObfuscatedPackageMap", "getRawObfuscatedPackageMap", "setRawObfuscatedPackageMap", "handleClassMapping", "", "clazz", "newClass", "handleMethodMapping", "", "returnType", "name", "arguments", "newClazz", "newMethod", "obfuscatedMethodInfo", "methodInfo", "originalClassName", "originalMethodName", "originalMethodDesc", "proguardClassName", "defaultClassName", "originalMethodInfo", "obfuscatedClassName", "obfuscatedMethodName", "obfuscatedMethodDesc", "parseMethodDesc", "Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector$DescInfo;", "desc", "isRawToObfuscated", "proguardPackageName", "originalPackage", "defaultPackage", "trimSquare", "Companion", "DescInfo", "apm-plugin"})
public final class MappingCollector
implements IMappingHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private HashMap<String, String> obfuscatedRawClassMap = new HashMap(2000);
    @NotNull
    private HashMap<String, String> rawObfuscatedClassMap = new HashMap(2000);
    @NotNull
    private HashMap<String, String> rawObfuscatedPackageMap = new HashMap(2000);
    @NotNull
    private final Map<String, Map<String, Set<MethodInfo>>> obfuscatedClassMethodMap = new HashMap();
    @NotNull
    private final Map<String, Map<String, Set<MethodInfo>>> originalClassMethodMap = new HashMap();
    @NotNull
    private static final String TAG = "MappingCollector";
    private static final int DEFAULT_CAPACITY = 2000;

    @NotNull
    public final HashMap<String, String> getObfuscatedRawClassMap() {
        return this.obfuscatedRawClassMap;
    }

    public final void setObfuscatedRawClassMap(@NotNull HashMap<String, String> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.obfuscatedRawClassMap = hashMap;
    }

    @NotNull
    public final HashMap<String, String> getRawObfuscatedClassMap() {
        return this.rawObfuscatedClassMap;
    }

    public final void setRawObfuscatedClassMap(@NotNull HashMap<String, String> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.rawObfuscatedClassMap = hashMap;
    }

    @NotNull
    public final HashMap<String, String> getRawObfuscatedPackageMap() {
        return this.rawObfuscatedPackageMap;
    }

    public final void setRawObfuscatedPackageMap(@NotNull HashMap<String, String> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.rawObfuscatedPackageMap = hashMap;
    }

    @Override
    public boolean handleClassMapping(@NotNull String clazz, @NotNull String newClass) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)newClass, (String)"newClass");
        ((Map)this.obfuscatedRawClassMap).put(newClass, clazz);
        ((Map)this.rawObfuscatedClassMap).put(clazz, newClass);
        int classNameLen = StringsKt.lastIndexOf$default((CharSequence)clazz, (char)'.', (int)0, (boolean)false, (int)6, null);
        int newClassNameLen = StringsKt.lastIndexOf$default((CharSequence)newClass, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (classNameLen > 0 && newClassNameLen > 0) {
            Map map = this.rawObfuscatedPackageMap;
            String string = clazz.substring(0, classNameLen);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = newClass.substring(0, newClassNameLen);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            map.put(string, string2);
        } else {
            PluginLog.INSTANCE.error(TAG, "class without package name: " + clazz + " -> " + newClass + ", please check input mapping", new Object[0]);
        }
        return true;
    }

    @Override
    public void handleMethodMapping(@NotNull String clazz, @NotNull String returnType, @NotNull String name, @NotNull String arguments, @NotNull String newClazz, @NotNull String newMethod) {
        Set methodSet2;
        Set methodSet;
        String obfuscatedClassName;
        Map methodMap;
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)newClazz, (String)"newClazz");
        Intrinsics.checkNotNullParameter((Object)newMethod, (String)"newMethod");
        String string = this.rawObfuscatedClassMap.get(clazz);
        if (string == null) {
            string = newClazz;
        }
        if ((methodMap = this.obfuscatedClassMethodMap.get(obfuscatedClassName = string)) == null) {
            methodMap = new HashMap();
            this.obfuscatedClassMethodMap.put(obfuscatedClassName, methodMap);
        }
        if ((methodSet = methodMap.get(newMethod)) == null) {
            methodSet = new LinkedHashSet();
            methodMap.put(newMethod, methodSet);
        }
        methodSet.add(new MethodInfo(clazz, returnType, name, arguments, null, 16, null));
        Map methodMap2 = this.originalClassMethodMap.get(clazz);
        if (methodMap2 == null) {
            methodMap2 = new HashMap();
            this.originalClassMethodMap.put(clazz, methodMap2);
        }
        if ((methodSet2 = methodMap2.get(name)) == null) {
            methodSet2 = new LinkedHashSet();
            methodMap2.put(name, methodSet2);
        }
        methodSet2.add(new MethodInfo(obfuscatedClassName, returnType, newMethod, arguments, null, 16, null));
    }

    @NotNull
    public final String originalClassName(@NotNull String proguardClassName, @NotNull String defaultClassName) {
        Intrinsics.checkNotNullParameter((Object)proguardClassName, (String)"proguardClassName");
        Intrinsics.checkNotNullParameter((Object)defaultClassName, (String)"defaultClassName");
        String string = this.obfuscatedRawClassMap.get(proguardClassName);
        if (string == null) {
            string = defaultClassName;
        }
        return string;
    }

    @NotNull
    public final String proguardClassName(@NotNull String originalClassName, @NotNull String defaultClassName) {
        Intrinsics.checkNotNullParameter((Object)originalClassName, (String)"originalClassName");
        Intrinsics.checkNotNullParameter((Object)defaultClassName, (String)"defaultClassName");
        String string = this.rawObfuscatedClassMap.get(originalClassName);
        if (string == null) {
            string = defaultClassName;
        }
        return string;
    }

    @NotNull
    public final String proguardPackageName(@NotNull String originalPackage, @NotNull String defaultPackage) {
        Intrinsics.checkNotNullParameter((Object)originalPackage, (String)"originalPackage");
        Intrinsics.checkNotNullParameter((Object)defaultPackage, (String)"defaultPackage");
        String string = this.rawObfuscatedPackageMap.get(originalPackage);
        if (string == null) {
            string = defaultPackage;
        }
        return string;
    }

    @NotNull
    public final MethodInfo originalMethodInfo(@Nullable String obfuscatedClassName, @NotNull String obfuscatedMethodName, @NotNull String obfuscatedMethodDesc) {
        Set<MethodInfo> methodSet;
        Intrinsics.checkNotNullParameter((Object)obfuscatedMethodName, (String)"obfuscatedMethodName");
        Intrinsics.checkNotNullParameter((Object)obfuscatedMethodDesc, (String)"obfuscatedMethodDesc");
        DescInfo descInfo = this.parseMethodDesc(obfuscatedMethodDesc, false);
        Map<String, Set<MethodInfo>> methodMap = this.obfuscatedClassMethodMap.get(obfuscatedClassName);
        if (methodMap != null && (methodSet = methodMap.get(obfuscatedMethodName)) != null) {
            for (MethodInfo methodInfo : methodSet) {
                if (!methodInfo.matches(descInfo.getReturnType(), descInfo.getArguments())) continue;
                MethodInfo newMethodInfo = new MethodInfo(methodInfo);
                newMethodInfo.setDesc(descInfo.getDesc());
                return newMethodInfo;
            }
        }
        MethodInfo defaultMethodInfo = MethodInfo.Companion.deFault();
        defaultMethodInfo.setDesc(descInfo.getDesc());
        defaultMethodInfo.setOriginalName(obfuscatedMethodName);
        return defaultMethodInfo;
    }

    @NotNull
    public final MethodInfo obfuscatedMethodInfo(@NotNull String originalClassName, @NotNull String originalMethodName, @NotNull String originalMethodDesc) {
        Set<MethodInfo> methodSet;
        Intrinsics.checkNotNullParameter((Object)originalClassName, (String)"originalClassName");
        Intrinsics.checkNotNullParameter((Object)originalMethodName, (String)"originalMethodName");
        Intrinsics.checkNotNullParameter((Object)originalMethodDesc, (String)"originalMethodDesc");
        DescInfo descInfo = this.parseMethodDesc(originalMethodDesc, true);
        Map<String, Set<MethodInfo>> methodMap = this.originalClassMethodMap.get(originalClassName);
        if (methodMap != null && (methodSet = methodMap.get(originalMethodName)) != null) {
            for (MethodInfo methodInfo : methodSet) {
                MethodInfo newMethodInfo = new MethodInfo(methodInfo);
                this.obfuscatedMethodInfo(newMethodInfo);
                if (!newMethodInfo.matches(descInfo.getReturnType(), descInfo.getArguments())) continue;
                newMethodInfo.setDesc(descInfo.getDesc());
                return newMethodInfo;
            }
        }
        MethodInfo defaultMethodInfo = MethodInfo.Companion.deFault();
        defaultMethodInfo.setDesc(descInfo.getDesc());
        defaultMethodInfo.setOriginalName(originalMethodName);
        return defaultMethodInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final void obfuscatedMethodInfo(MethodInfo methodInfo) {
        String methodReturnType;
        String key;
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        String methodArguments = methodInfo.getOriginalArguments();
        Object object = methodArguments;
        Regex regex = new Regex(",");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        int $i$f$toTypedArray = 0;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] args = stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (String str : args) {
            String key2 = StringsKt.replace$default((String)StringsKt.replace$default((String)str, (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null);
            if (this.rawObfuscatedClassMap.containsKey(key2)) {
                String string = this.rawObfuscatedClassMap.get(key2);
                Intrinsics.checkNotNull((Object)string);
                stringBuffer.append(StringsKt.replace$default((String)str, (String)key2, (String)string, (boolean)false, (int)4, null));
            } else {
                stringBuffer.append(str);
            }
            stringBuffer.append(',');
        }
        if (((CharSequence)stringBuffer).length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        if (this.rawObfuscatedClassMap.containsKey(key = this.trimSquare(methodReturnType = methodInfo.getOriginalType()))) {
            String string = this.rawObfuscatedClassMap.get(key);
            Intrinsics.checkNotNull((Object)string);
            methodReturnType = StringsKt.replace$default((String)methodReturnType, (String)key, (String)string, (boolean)false, (int)4, null);
        }
        String string = stringBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuffer.toString()");
        methodInfo.setOriginalArguments(string);
        methodInfo.setOriginalType(methodReturnType);
    }

    @NotNull
    public final String trimSquare(@NotNull String $this$trimSquare) {
        Intrinsics.checkNotNullParameter((Object)$this$trimSquare, (String)"<this>");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)$this$trimSquare, (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null);
    }

    private final DescInfo parseMethodDesc(String desc, boolean isRawToObfuscated) {
        String key;
        Type type;
        DescInfo descInfo = new DescInfo();
        StringBuffer argumentsBuffer = new StringBuffer();
        Type[] argsObj = Type.getArgumentTypes((String)desc);
        StringBuffer descBuffer = new StringBuffer();
        descBuffer.append('(');
        Intrinsics.checkNotNullExpressionValue((Object)argsObj, (String)"argsObj");
        for (Type type2 : argsObj) {
            String string = type2.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.className");
            String key2 = this.trimSquare(string);
            if (isRawToObfuscated) {
                if (this.rawObfuscatedClassMap.containsKey(key2)) {
                    String string2 = type2.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type.className");
                    String string3 = this.rawObfuscatedClassMap.get(key2);
                    Intrinsics.checkNotNull((Object)string3);
                    argumentsBuffer.append(StringsKt.replace$default((String)string2, (String)key2, (String)string3, (boolean)false, (int)4, null));
                    String string4 = type2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"type.toString()");
                    String string5 = this.rawObfuscatedClassMap.get(key2);
                    Intrinsics.checkNotNull((Object)string5);
                    descBuffer.append(StringsKt.replace$default((String)string4, (String)key2, (String)string5, (boolean)false, (int)4, null));
                } else {
                    argumentsBuffer.append(type2.getClassName());
                    descBuffer.append(type2.toString());
                }
            } else if (this.obfuscatedRawClassMap.containsKey(key2)) {
                String string6 = type2.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"type.className");
                String string7 = this.obfuscatedRawClassMap.get(key2);
                Intrinsics.checkNotNull((Object)string7);
                argumentsBuffer.append(StringsKt.replace$default((String)string6, (String)key2, (String)string7, (boolean)false, (int)4, null));
                String string8 = type2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"type.toString()");
                String string9 = this.obfuscatedRawClassMap.get(key2);
                Intrinsics.checkNotNull((Object)string9);
                descBuffer.append(StringsKt.replace$default((String)string8, (String)key2, (String)string9, (boolean)false, (int)4, null));
            } else {
                argumentsBuffer.append(type2.getClassName());
                descBuffer.append(type2.toString());
            }
            argumentsBuffer.append(',');
        }
        descBuffer.append(')');
        try {
            Type type3 = Type.getReturnType((String)desc);
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"{\n            Type.getReturnType(desc)\n        }");
            type = type3;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Type type4 = Type.getReturnType((String)(desc + ";"));
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"{\n            Type.getRe\u2026nType(\"$desc;\")\n        }");
            type = type4;
        }
        Type returnType = type;
        if (isRawToObfuscated) {
            String string = returnType.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"returnType.className");
            key = this.trimSquare(string);
            if (this.rawObfuscatedClassMap.containsKey(key)) {
                String string10 = returnType.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"returnType.className");
                String string11 = this.rawObfuscatedClassMap.get(key);
                Intrinsics.checkNotNull((Object)string11);
                descInfo.setReturnType(StringsKt.replace$default((String)string10, (String)key, (String)string11, (boolean)false, (int)4, null));
                String string12 = returnType.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"returnType.toString()");
                String string13 = this.rawObfuscatedClassMap.get(key);
                Intrinsics.checkNotNull((Object)string13);
                descBuffer.append(StringsKt.replace$default((String)string12, (String)key, (String)string13, (boolean)false, (int)4, null));
            } else {
                descInfo.setReturnType(returnType.getClassName());
                descBuffer.append(returnType.toString());
            }
        } else {
            String string = returnType.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"returnType.className");
            key = this.trimSquare(string);
            if (this.obfuscatedRawClassMap.containsKey(key)) {
                String string14 = returnType.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"returnType.className");
                String string15 = this.obfuscatedRawClassMap.get(key);
                Intrinsics.checkNotNull((Object)string15);
                descInfo.setReturnType(StringsKt.replace$default((String)string14, (String)key, (String)string15, (boolean)false, (int)4, null));
                String string16 = returnType.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"returnType.toString()");
                String string17 = this.obfuscatedRawClassMap.get(key);
                Intrinsics.checkNotNull((Object)string17);
                descBuffer.append(StringsKt.replace$default((String)string16, (String)key, (String)string17, (boolean)false, (int)4, null));
            } else {
                descInfo.setReturnType(returnType.getClassName());
                descBuffer.append(returnType.toString());
            }
        }
        if (((CharSequence)argumentsBuffer).length() > 0) {
            argumentsBuffer.deleteCharAt(argumentsBuffer.length() - 1);
        }
        descInfo.setArguments(argumentsBuffer.toString());
        descInfo.setDesc(descBuffer.toString());
        return descInfo;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000e\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u0004R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\"\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector$DescInfo;", "", "()V", "<set-?>", "", "arguments", "getArguments", "()Ljava/lang/String;", "desc", "getDesc", "returnType", "getReturnType", "setArguments", "", "setDesc", "setReturnType", "apm-plugin"})
    private static final class DescInfo {
        @Nullable
        private String desc;
        @Nullable
        private String arguments;
        @Nullable
        private String returnType;

        @Nullable
        public final String getDesc() {
            return this.desc;
        }

        @Nullable
        public final String getArguments() {
            return this.arguments;
        }

        @Nullable
        public final String getReturnType() {
            return this.returnType;
        }

        public final void setArguments(@Nullable String arguments) {
            this.arguments = arguments;
        }

        public final void setReturnType(@Nullable String returnType) {
            this.returnType = returnType;
        }

        public final void setDesc(@Nullable String desc) {
            this.desc = desc;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector$Companion;", "", "()V", "DEFAULT_CAPACITY", "", "TAG", "", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

