/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace.methodTrace;

import com.cloud.apm.plugin.tasks.trace.TraceConfiguration;
import com.cloud.apm.plugin.tasks.trace.mapping.MappingCollector;
import com.cloud.apm.plugin.tasks.trace.methodTrace.AgpCompat;
import com.cloud.apm.plugin.tasks.trace.methodTrace.MethodCollector;
import com.cloud.apm.plugin.tasks.trace.methodTrace.TraceClassWriter;
import com.cloud.apm.plugin.tasks.trace.methodTrace.TraceMethod;
import com.cloud.apm.plugin.utils.FileUtil;
import com.cloud.apm.plugin.utils.PluginLog;
import com.cloud.apm.plugin.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.util.CheckClassAdapter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u000389:BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J(\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J$\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\n2\b\u0010!\u001a\u0004\u0018\u00010\nH\u0002J(\u0010\"\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010\n2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0002J(\u0010%\u001a\u00020\u00112\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u00160'j\b\u0012\u0004\u0012\u00020\u0016`(2\u0006\u0010)\u001a\u00020\u0016H\u0002JB\u0010*\u001a\u00020\u00112\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0018\u00010,2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0018\u00010,2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000fJ@\u0010.\u001a\u00020\u00112\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0018\u00010,2\u0010\u00100\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u000302012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J@\u00103\u001a\u00020\u00112\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0018\u00010,2\u0010\u00100\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u000302012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u001a\u00105\u001a\u00020\u00112\u0006\u00106\u001a\u0002072\b\u0010 \u001a\u0004\u0018\u00010\nH\u0002R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodTracer;", "", "executor", "Ljava/util/concurrent/ExecutorService;", "mappingCollector", "Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector;", "configuration", "Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;", "collectedMethodMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/cloud/apm/plugin/tasks/trace/methodTrace/TraceMethod;", "collectedClassExtendMap", "(Ljava/util/concurrent/ExecutorService;Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector;Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;Ljava/util/concurrent/ConcurrentHashMap;Ljava/util/concurrent/ConcurrentHashMap;)V", "traceError", "", "finishQuietly", "", "stream", "Ljava/util/zip/ZipOutputStream;", "innerTraceMethodFromJar", "input", "Ljava/io/File;", "output", "classLoader", "Ljava/lang/ClassLoader;", "skipCheckClass", "innerTraceMethodFromSrc", "ignoreCheckClass", "insertWindowFocusChangeMethod", "cv", "Lorg/objectweb/asm/ClassVisitor;", "classname", "superClassName", "isActivityOrSubClass", "className", "mCollectedClassExtendMap", "listClassFiles", "classFiles", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "folder", "trace", "srcFolderList", "", "dependencyJarList", "traceMethodFromJar", "dependencyMap", "futures", "", "Ljava/util/concurrent/Future;", "traceMethodFromSrc", "srcMap", "traceWindowFocusChangeMethod", "mv", "Lorg/objectweb/asm/MethodVisitor;", "Companion", "TraceClassAdapter", "TraceMethodAdapter", "apm-plugin"})
public final class MethodTracer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final MappingCollector mappingCollector;
    @NotNull
    private final TraceConfiguration configuration;
    @NotNull
    private final ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
    @NotNull
    private final ConcurrentHashMap<String, String> collectedClassExtendMap;
    private volatile boolean traceError;
    @NotNull
    private static final String TAG = "MethodTracer";
    @NotNull
    private static final AtomicInteger traceMethodCount = new AtomicInteger();

    public MethodTracer(@NotNull ExecutorService executor2, @NotNull MappingCollector mappingCollector, @NotNull TraceConfiguration configuration, @NotNull ConcurrentHashMap<String, TraceMethod> collectedMethodMap, @NotNull ConcurrentHashMap<String, String> collectedClassExtendMap) {
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)mappingCollector, (String)"mappingCollector");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(collectedMethodMap, (String)"collectedMethodMap");
        Intrinsics.checkNotNullParameter(collectedClassExtendMap, (String)"collectedClassExtendMap");
        this.executor = executor2;
        this.mappingCollector = mappingCollector;
        this.configuration = configuration;
        this.collectedMethodMap = collectedMethodMap;
        this.collectedClassExtendMap = collectedClassExtendMap;
    }

    public final void trace(@Nullable Map<File, ? extends File> srcFolderList, @Nullable Map<File, ? extends File> dependencyJarList, @NotNull ClassLoader classLoader, boolean ignoreCheckClass) throws ExecutionException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        List futures = new LinkedList();
        this.traceMethodFromSrc(srcFolderList, futures, classLoader, ignoreCheckClass);
        this.traceMethodFromJar(dependencyJarList, futures, classLoader, ignoreCheckClass);
        for (Future future : futures) {
            future.get();
        }
        if (!(!this.traceError)) {
            boolean bl = false;
            PluginLog.INSTANCE.error(TAG, "something wrong with trace, see detail log before", new Object[0]);
            Unit unit = Unit.INSTANCE;
            throw new IllegalArgumentException(unit.toString());
        }
        futures.clear();
    }

    private final void traceMethodFromSrc(Map<File, ? extends File> srcMap, List<Future<?>> futures, ClassLoader classLoader, boolean skipCheckClass) {
        block1: {
            Map<File, ? extends File> map = srcMap;
            if (map == null) break block1;
            Map<File, ? extends File> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<File, ? extends File>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<File, ? extends File> element$iv;
                Map.Entry<File, ? extends File> entry = element$iv = iterator.next();
                boolean bl = false;
                File key = entry.getKey();
                File value = entry.getValue();
                Future<?> future = this.executor.submit(() -> MethodTracer.traceMethodFromSrc$lambda-2$lambda-1(this, key, value, classLoader, skipCheckClass));
                Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit {\n      \u2026CheckClass)\n            }");
                futures.add(future);
            }
        }
    }

    private final void traceMethodFromJar(Map<File, ? extends File> dependencyMap, List<Future<?>> futures, ClassLoader classLoader, boolean skipCheckClass) {
        block1: {
            Map<File, ? extends File> map = dependencyMap;
            if (map == null) break block1;
            Map<File, ? extends File> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<File, ? extends File>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<File, ? extends File> element$iv;
                Map.Entry<File, ? extends File> entry = element$iv = iterator.next();
                boolean bl = false;
                File key = entry.getKey();
                File value = entry.getValue();
                Future<?> future = this.executor.submit(() -> MethodTracer.traceMethodFromJar$lambda-4$lambda-3(this, key, value, classLoader, skipCheckClass));
                Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit {\n      \u2026CheckClass)\n            }");
                futures.add(future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void innerTraceMethodFromSrc(File input, File output, ClassLoader classLoader, boolean ignoreCheckClass) {
        ArrayList<File> classFileList = new ArrayList<File>();
        if (input.isDirectory()) {
            this.listClassFiles(classFileList, input);
        } else {
            classFileList.add(input);
        }
        for (File classFile : classFileList) {
            Object changedFileOutput;
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                String changedFileInputFullPath = classFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)changedFileInputFullPath, (String)"changedFileInputFullPath");
                String string = input.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.absolutePath");
                String string2 = output.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"output.absolutePath");
                changedFileOutput = new File(StringsKt.replace$default((String)changedFileInputFullPath, (String)string, (String)string2, (boolean)false, (int)4, null));
                if (Intrinsics.areEqual((Object)((File)changedFileOutput).getCanonicalPath(), (Object)classFile.getCanonicalPath())) {
                    throw new RuntimeException("Input file(" + classFile.getCanonicalPath() + ") should not be same with output!");
                }
                if (!((File)changedFileOutput).exists()) {
                    ((File)changedFileOutput).getParentFile().mkdirs();
                }
                ((File)changedFileOutput).createNewFile();
                String string3 = classFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classFile.name");
                if (MethodCollector.Companion.isNeedTraceFile(string3)) {
                    inputStream = new FileInputStream(classFile);
                    ClassReader classReader = new ClassReader(inputStream);
                    ClassWriter classWriter = new TraceClassWriter(2, classLoader);
                    ClassVisitor classVisitor = new TraceClassAdapter(AgpCompat.INSTANCE.getAsmApi(), (ClassVisitor)classWriter);
                    classReader.accept(classVisitor, 8);
                    FileUtil.INSTANCE.closeQuietly(inputStream);
                    byte[] data = classWriter.toByteArray();
                    if (!ignoreCheckClass) {
                        try {
                            ClassReader cr = new ClassReader(data);
                            ClassWriter cw = new ClassWriter(0);
                            ClassVisitor check = (ClassVisitor)new CheckClassAdapter((ClassVisitor)cw);
                            cr.accept(check, 8);
                        }
                        catch (Throwable e) {
                            Object[] objectArray = new Object[]{classFile, e.getMessage()};
                            PluginLog.INSTANCE.warning(TAG, "[innerTraceMethodFromSrc] Check source class %s failed : %d", objectArray);
                            this.traceError = true;
                        }
                    }
                    outputStream = output.isDirectory() ? new FileOutputStream((File)changedFileOutput) : new FileOutputStream(output);
                    outputStream.write(data);
                    FileUtil.INSTANCE.closeQuietly(outputStream);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)classFile, (String)"classFile");
                FileUtil.INSTANCE.copyFileUsingStream(classFile, (File)changedFileOutput);
            }
            catch (Exception e) {
                changedFileOutput = new Object[]{input.getName(), e.getMessage()};
                PluginLog.INSTANCE.printErrStackTrace(TAG, e, "[innerTraceMethodFromSrc] input: %s failed: %s", (Object[])changedFileOutput);
                try {
                    changedFileOutput = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(input.toPath(), output.toPath(), (CopyOption[])changedFileOutput);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                FileUtil.INSTANCE.closeQuietly(inputStream);
                FileUtil.INSTANCE.closeQuietly(outputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void innerTraceMethodFromJar(File input, File output, ClassLoader classLoader, boolean skipCheckClass) {
        ZipOutputStream zipOutputStream = null;
        ZipFile zipFile = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(output));
            zipFile = new ZipFile(input);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                InputStream inputStream;
                ZipEntry zipEntry = enumeration.nextElement();
                String zipEntryName = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)zipEntryName, (String)"zipEntryName");
                if (Util.INSTANCE.preventZipSlip(output, zipEntryName)) {
                    Object[] objectArray = new Object[]{zipEntryName};
                    PluginLog.INSTANCE.error(TAG, "[innerTraceMethodFromJar] Unzip entry %s failed!", objectArray);
                    continue;
                }
                if (MethodCollector.Companion.isNeedTraceFile(zipEntryName)) {
                    try {
                        inputStream = zipFile.getInputStream(zipEntry);
                        ClassReader classReader = new ClassReader(inputStream);
                        ClassWriter classWriter = new TraceClassWriter(2, classLoader);
                        ClassVisitor classVisitor = new TraceClassAdapter(AgpCompat.INSTANCE.getAsmApi(), (ClassVisitor)classWriter);
                        classReader.accept(classVisitor, 8);
                        byte[] data = classWriter.toByteArray();
                        if (!skipCheckClass) {
                            ClassWriter writer;
                            try {
                                ClassReader reader = new ClassReader(data);
                                writer = new ClassWriter(0);
                                ClassVisitor visitor = (ClassVisitor)new CheckClassAdapter((ClassVisitor)writer);
                                reader.accept(visitor, 8);
                            }
                            catch (Throwable e) {
                                writer = new ClassWriter[]{zipEntryName, e.getMessage()};
                                PluginLog.INSTANCE.warning(TAG, "[innerTraceMethodFromJar] Check jar Class %s failed: %s", (Object[])writer);
                                this.traceError = true;
                            }
                        }
                        InputStream byteArrayInputStream = new ByteArrayInputStream(data);
                        ZipEntry newZipEntry = new ZipEntry(zipEntryName);
                        FileUtil.INSTANCE.addZipEntry(zipOutputStream, newZipEntry, byteArrayInputStream);
                    }
                    catch (Exception e) {
                        PluginLog.INSTANCE.printErrStackTrace(TAG, e, "[innerTraceMethodFromJar] entry: " + zipEntryName + " input: " + input + " output: " + output + " failed: " + e.getMessage() + "\n", new Object[0]);
                        InputStream inputStream2 = zipFile.getInputStream(zipEntry);
                        ZipEntry newZipEntry = new ZipEntry(zipEntryName);
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"inputStream");
                        FileUtil.INSTANCE.addZipEntry(zipOutputStream, newZipEntry, inputStream2);
                    }
                    continue;
                }
                inputStream = zipFile.getInputStream(zipEntry);
                ZipEntry newZipEntry = new ZipEntry(zipEntryName);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                FileUtil.INSTANCE.addZipEntry(zipOutputStream, newZipEntry, inputStream);
            }
            this.finishQuietly(zipOutputStream);
            FileUtil.INSTANCE.flushQuietly(zipOutputStream);
            FileUtil.INSTANCE.closeQuietly(zipOutputStream);
            FileUtil.INSTANCE.closeQuietly(zipFile);
        }
        catch (Exception e) {
            try {
                Object[] zipEntry = new Object[]{input, output, e.getMessage()};
                PluginLog.INSTANCE.printErrStackTrace(TAG, e, "[innerTraceMethodFromJar] input: %s output: %s failed: %s\n", zipEntry);
                this.finishQuietly(zipOutputStream);
                FileUtil.INSTANCE.closeQuietly(zipOutputStream);
                FileUtil.INSTANCE.closeQuietly(zipFile);
                zipFile = null;
                zipOutputStream = null;
                try {
                    if (input.length() > 0L) {
                        zipEntry = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        Files.copy(input.toPath(), output.toPath(), (CopyOption[])zipEntry);
                    } else {
                        zipEntry = new Object[]{input};
                        PluginLog.INSTANCE.error(TAG, "[innerTraceMethodFromJar] input:%s is empty", zipEntry);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                this.finishQuietly(zipOutputStream);
                FileUtil.INSTANCE.flushQuietly(zipOutputStream);
                FileUtil.INSTANCE.closeQuietly(zipOutputStream);
                FileUtil.INSTANCE.closeQuietly(zipFile);
            }
            catch (Throwable throwable) {
                this.finishQuietly(zipOutputStream);
                FileUtil.INSTANCE.flushQuietly(zipOutputStream);
                FileUtil.INSTANCE.closeQuietly(zipOutputStream);
                FileUtil.INSTANCE.closeQuietly(zipFile);
                throw throwable;
            }
        }
    }

    private final void finishQuietly(ZipOutputStream stream) {
        try {
            ZipOutputStream zipOutputStream = stream;
            if (zipOutputStream != null) {
                zipOutputStream.finish();
            }
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            PluginLog.INSTANCE.error(TAG, "[innerTraceMethodFromJar] close stream fail: %s", objectArray);
        }
    }

    private final void listClassFiles(ArrayList<File> classFiles, File folder) {
        File[] files = folder.listFiles();
        if (files == null) {
            Object[] objectArray = new Object[]{folder.getAbsolutePath()};
            PluginLog.INSTANCE.error(TAG, "[listClassFiles] files is null! %s", objectArray);
            return;
        }
        for (File file : files) {
            if (file == null) continue;
            if (file.isDirectory()) {
                this.listClassFiles(classFiles, file);
                continue;
            }
            if (!file.isFile()) continue;
            classFiles.add(file);
        }
    }

    private final boolean isActivityOrSubClass(String className, ConcurrentHashMap<String, String> mCollectedClassExtendMap) {
        String string = className;
        Intrinsics.checkNotNull((Object)string);
        String realClassName = StringsKt.replace$default((String)string, (String)".", (String)"/", (boolean)false, (int)4, null);
        return Intrinsics.areEqual((Object)realClassName, (Object)"android/support/v4/app/FragmentActivity") || Intrinsics.areEqual((Object)realClassName, (Object)"android/support/v7/app/AppCompatActivity") || Intrinsics.areEqual((Object)realClassName, (Object)"android/app/Activity") || Intrinsics.areEqual((Object)realClassName, (Object)"androidx/appcompat/app/AppCompatActivity") ? true : (!mCollectedClassExtendMap.containsKey(realClassName) ? false : this.isActivityOrSubClass(mCollectedClassExtendMap.get(realClassName), mCollectedClassExtendMap));
    }

    private final void traceWindowFocusChangeMethod(MethodVisitor mv, String classname) {
        PluginLog.INSTANCE.info(TAG, "[traceWindowFocusChangeMethod] class:" + classname, new Object[0]);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitMethodInsn(184, "com/cloud/apm/services/performance/utils/MethodAssistant", "at", "(Landroid/app/Activity;Z)V", false);
    }

    private final void insertWindowFocusChangeMethod(ClassVisitor cv, String classname, String superClassName) {
        MethodVisitor methodVisitor = cv.visitMethod(1, "onWindowFocusChanged", "(Z)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitMethodInsn(183, superClassName, "onWindowFocusChanged", "(Z)V", false);
        Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"methodVisitor");
        this.traceWindowFocusChangeMethod(methodVisitor, classname);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
    }

    private static final void traceMethodFromSrc$lambda-2$lambda-1(MethodTracer this$0, File $key, File $value, ClassLoader $classLoader, boolean $skipCheckClass) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$classLoader, (String)"$classLoader");
        this$0.innerTraceMethodFromSrc($key, $value, $classLoader, $skipCheckClass);
    }

    private static final void traceMethodFromJar$lambda-4$lambda-3(MethodTracer this$0, File $key, File $value, ClassLoader $classLoader, boolean $skipCheckClass) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$classLoader, (String)"$classLoader");
        this$0.innerTraceMethodFromJar($key, $value, $classLoader, $skipCheckClass);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005JG\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J?\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u001cR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodTracer$TraceClassAdapter;", "Lorg/objectweb/asm/ClassVisitor;", "api", "", "classVisitor", "(Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodTracer;ILorg/objectweb/asm/ClassVisitor;)V", "className", "", "hasWindowFocusMethod", "", "isABSClass", "isActivityOrSubClass", "isNeedTrace", "superName", "visit", "", "version", "access", "name", "signature", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitEnd", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "desc", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "apm-plugin"})
    private final class TraceClassAdapter
    extends ClassVisitor {
        @Nullable
        private String className;
        @Nullable
        private String superName;
        private boolean isABSClass;
        private boolean hasWindowFocusMethod;
        private boolean isActivityOrSubClass;
        private boolean isNeedTrace;

        public TraceClassAdapter(@Nullable int api, ClassVisitor classVisitor) {
            super(api, classVisitor);
        }

        public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @NotNull String[] interfaces) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)interfaces, (String)"interfaces");
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            this.superName = superName;
            this.isActivityOrSubClass = MethodTracer.this.isActivityOrSubClass(this.className, MethodTracer.this.collectedClassExtendMap);
            TraceConfiguration traceConfiguration = MethodTracer.this.configuration;
            String string = this.className;
            Intrinsics.checkNotNull((Object)string);
            this.isNeedTrace = MethodCollector.Companion.isNeedTrace(traceConfiguration, string, MethodTracer.this.mappingCollector);
            if ((access & 0x400) > 0 || (access & 0x200) > 0) {
                this.isABSClass = true;
            }
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor methodVisitor;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            if (!this.hasWindowFocusMethod) {
                this.hasWindowFocusMethod = MethodCollector.Companion.isWindowFocusChangeMethod(name, desc);
            }
            if (this.isABSClass) {
                MethodVisitor methodVisitor2 = super.visitMethod(access, name, desc, signature, exceptions);
                methodVisitor = methodVisitor2;
                Intrinsics.checkNotNullExpressionValue((Object)methodVisitor2, (String)"{\n                super.\u2026exceptions)\n            }");
            } else {
                MethodVisitor methodVisitor3 = this.cv.visitMethod(access, name, desc, signature, exceptions);
                methodVisitor = (MethodVisitor)new TraceMethodAdapter(this.api, methodVisitor3, access, name, desc, this.className, this.hasWindowFocusMethod, this.isActivityOrSubClass, this.isNeedTrace);
            }
            return methodVisitor;
        }

        public void visitEnd() {
            if (!this.hasWindowFocusMethod && this.isActivityOrSubClass && this.isNeedTrace) {
                ClassVisitor classVisitor = this.cv;
                Intrinsics.checkNotNullExpressionValue((Object)classVisitor, (String)"cv");
                MethodTracer.this.insertWindowFocusChangeMethod(classVisitor, this.className, this.superName);
            }
            super.visitEnd();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0014R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodTracer$TraceMethodAdapter;", "Lorg/objectweb/asm/commons/AdviceAdapter;", "api", "", "mv", "Lorg/objectweb/asm/MethodVisitor;", "access", "name", "", "desc", "className", "hasWindowFocusMethod", "", "isActivityOrSubClass", "isNeedTrace", "(Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodTracer;ILorg/objectweb/asm/MethodVisitor;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZZ)V", "methodName", "checkNeedTraceWindowFocusChangeMethod", "traceMethod", "Lcom/cloud/apm/plugin/tasks/trace/methodTrace/TraceMethod;", "onMethodEnter", "", "onMethodExit", "opcode", "apm-plugin"})
    private final class TraceMethodAdapter
    extends AdviceAdapter {
        @NotNull
        private final String methodName;
        @Nullable
        private final String className;
        private final boolean hasWindowFocusMethod;
        private final boolean isNeedTrace;
        private final boolean isActivityOrSubClass;

        public TraceMethodAdapter(@Nullable int api, MethodVisitor mv, @NotNull int access, @Nullable String name, @Nullable String desc, String className, boolean hasWindowFocusMethod, boolean isActivityOrSubClass, boolean isNeedTrace) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(api, mv, access, name, desc);
            String string = className;
            Intrinsics.checkNotNull((Object)string);
            String string2 = desc;
            Intrinsics.checkNotNull((Object)string2);
            TraceMethod traceMethod = TraceMethod.Companion.create(0, access, string, name, string2);
            this.methodName = traceMethod.getRealMethodName();
            this.hasWindowFocusMethod = hasWindowFocusMethod;
            this.className = className;
            this.isActivityOrSubClass = isActivityOrSubClass;
            this.isNeedTrace = isNeedTrace;
        }

        protected void onMethodEnter() {
            TraceMethod traceMethod = (TraceMethod)MethodTracer.this.collectedMethodMap.get(this.methodName);
            if (traceMethod != null) {
                traceMethodCount.incrementAndGet();
                this.mv.visitLdcInsn((Object)traceMethod.getId());
                this.mv.visitMethodInsn(184, "com/cloud/apm/services/performance/utils/MethodAssistant", "enter", "(I)V", false);
                if (this.checkNeedTraceWindowFocusChangeMethod(traceMethod)) {
                    MethodVisitor methodVisitor = this.mv;
                    Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"mv");
                    MethodTracer.this.traceWindowFocusChangeMethod(methodVisitor, this.className);
                }
            }
        }

        protected void onMethodExit(int opcode) {
            TraceMethod traceMethod = (TraceMethod)MethodTracer.this.collectedMethodMap.get(this.methodName);
            if (traceMethod != null) {
                traceMethodCount.incrementAndGet();
                this.mv.visitLdcInsn((Object)traceMethod.getId());
                this.mv.visitMethodInsn(184, "com/cloud/apm/services/performance/utils/MethodAssistant", "exit", "(I)V", false);
            }
        }

        private final boolean checkNeedTraceWindowFocusChangeMethod(TraceMethod traceMethod) {
            if (this.hasWindowFocusMethod && this.isActivityOrSubClass && this.isNeedTrace) {
                String string = this.className;
                Intrinsics.checkNotNull((Object)string);
                TraceMethod windowFocusChangeMethod = TraceMethod.Companion.create(-1, 1, string, "onWindowFocusChanged", "(Z)V");
                if (Intrinsics.areEqual((Object)windowFocusChangeMethod, (Object)traceMethod)) {
                    return true;
                }
            }
            return false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodTracer$Companion;", "", "()V", "TAG", "", "traceMethodCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

