/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace;

import com.cloud.apm.plugin.tasks.trace.mapping.MappingCollector;
import com.cloud.apm.plugin.utils.FileUtil;
import com.cloud.apm.plugin.utils.PluginLog;
import com.cloud.apm.plugin.utils.Util;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001,BG\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010\u0010R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000e\"\u0004\b&\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;", "", "packageName", "", "mappingDir", "baseMethodMapPath", "methodMapFilePath", "ignoreMethodMapFilePath", "blockListFilePath", "traceClassOut", "skipCheckClass", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getBaseMethodMapPath", "()Ljava/lang/String;", "setBaseMethodMapPath", "(Ljava/lang/String;)V", "getBlockListFilePath", "setBlockListFilePath", "blockSet", "Ljava/util/HashSet;", "getBlockSet", "()Ljava/util/HashSet;", "setBlockSet", "(Ljava/util/HashSet;)V", "getIgnoreMethodMapFilePath", "setIgnoreMethodMapFilePath", "keyOfPrefixProguardClass", "keyOfPrefixProguardPackage", "getMappingDir", "setMappingDir", "getMethodMapFilePath", "setMethodMapFilePath", "getSkipCheckClass", "()Z", "setSkipCheckClass", "(Z)V", "getTraceClassOut", "setTraceClassOut", "parseBlockFile", "", "processor", "Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector;", "toString", "Builder", "apm-plugin"})
public final class TraceConfiguration {
    @Nullable
    private String packageName;
    @NotNull
    private String mappingDir;
    @NotNull
    private String baseMethodMapPath;
    @NotNull
    private String methodMapFilePath;
    @NotNull
    private String ignoreMethodMapFilePath;
    @NotNull
    private String blockListFilePath;
    @NotNull
    private String traceClassOut;
    private boolean skipCheckClass;
    @NotNull
    private final String keyOfPrefixProguardClass;
    @NotNull
    private final String keyOfPrefixProguardPackage;
    @NotNull
    private HashSet<String> blockSet;

    public TraceConfiguration(@Nullable String packageName, @NotNull String mappingDir, @NotNull String baseMethodMapPath, @NotNull String methodMapFilePath, @NotNull String ignoreMethodMapFilePath, @NotNull String blockListFilePath, @NotNull String traceClassOut, boolean skipCheckClass) {
        Intrinsics.checkNotNullParameter((Object)mappingDir, (String)"mappingDir");
        Intrinsics.checkNotNullParameter((Object)baseMethodMapPath, (String)"baseMethodMapPath");
        Intrinsics.checkNotNullParameter((Object)methodMapFilePath, (String)"methodMapFilePath");
        Intrinsics.checkNotNullParameter((Object)ignoreMethodMapFilePath, (String)"ignoreMethodMapFilePath");
        Intrinsics.checkNotNullParameter((Object)blockListFilePath, (String)"blockListFilePath");
        Intrinsics.checkNotNullParameter((Object)traceClassOut, (String)"traceClassOut");
        this.packageName = packageName;
        this.mappingDir = mappingDir;
        this.baseMethodMapPath = baseMethodMapPath;
        this.methodMapFilePath = methodMapFilePath;
        this.ignoreMethodMapFilePath = ignoreMethodMapFilePath;
        this.blockListFilePath = blockListFilePath;
        this.traceClassOut = traceClassOut;
        this.skipCheckClass = skipCheckClass;
        this.keyOfPrefixProguardClass = "-keepclass ";
        this.keyOfPrefixProguardPackage = "-keeppackage ";
        this.blockSet = new HashSet();
    }

    @NotNull
    public final String getMappingDir() {
        return this.mappingDir;
    }

    public final void setMappingDir(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mappingDir = string;
    }

    @NotNull
    public final String getBaseMethodMapPath() {
        return this.baseMethodMapPath;
    }

    public final void setBaseMethodMapPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.baseMethodMapPath = string;
    }

    @NotNull
    public final String getMethodMapFilePath() {
        return this.methodMapFilePath;
    }

    public final void setMethodMapFilePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.methodMapFilePath = string;
    }

    @NotNull
    public final String getIgnoreMethodMapFilePath() {
        return this.ignoreMethodMapFilePath;
    }

    public final void setIgnoreMethodMapFilePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ignoreMethodMapFilePath = string;
    }

    @NotNull
    public final String getBlockListFilePath() {
        return this.blockListFilePath;
    }

    public final void setBlockListFilePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.blockListFilePath = string;
    }

    @NotNull
    public final String getTraceClassOut() {
        return this.traceClassOut;
    }

    public final void setTraceClassOut(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.traceClassOut = string;
    }

    public final boolean getSkipCheckClass() {
        return this.skipCheckClass;
    }

    public final void setSkipCheckClass(boolean bl) {
        this.skipCheckClass = bl;
    }

    @NotNull
    public final HashSet<String> getBlockSet() {
        return this.blockSet;
    }

    public final void setBlockSet(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.blockSet = hashSet;
    }

    /*
     * WARNING - void declaration
     */
    public final int parseBlockFile(@NotNull MappingCollector processor) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        PluginLog.INSTANCE.debug("TraceConfiguration", "[parseBlockFile] BlockFile path: " + this.blockListFilePath, new Object[0]);
        Object blockStr = "[package]\n-keeppackage android/\n-keeppackage androidx/\n-keeppackage kotlin/\n-keeppackage com/cloud/apm/plugin/\n-keeppackage com/cloud/apm/\n-keeppackage com/cloud/lts/\n";
        if (((CharSequence)this.blockListFilePath).length() > 0) {
            blockStr = (String)blockStr + (String)blockStr + FileUtil.INSTANCE.readFileAsString(this.blockListFilePath);
        }
        Object $this$trim$iv = blockStr;
        boolean $i$f$trim22 = false;
        CharSequence $this$trim$iv$iv22 = (CharSequence)$this$trim$iv;
        boolean $i$f$trim = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv22.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv22.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        $this$trim$iv = StringsKt.replace$default((String)StringsKt.replace$default((String)((Object)$this$trim$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (String)"/", (String)".", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
        Regex $i$f$trim22 = new Regex("\n");
        int $this$trim$iv$iv22 = 0;
        $this$trim$iv = $i$f$trim22.split((CharSequence)$this$trim$iv, $this$trim$iv$iv22);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] blockArray = stringArray;
        if (!(blockArray.length == 0)) {
            String[] $this$forEach$iv = blockArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (((CharSequence)it).length() == 0 || StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"[", (boolean)false, (int)2, null)) continue;
                if (StringsKt.startsWith$default((String)it, (String)this.keyOfPrefixProguardClass, (boolean)false, (int)2, null)) {
                    String proguardClass = StringsKt.replace$default((String)it, (String)this.keyOfPrefixProguardClass, (String)"", (boolean)false, (int)4, null);
                    this.blockSet.add(processor.proguardClassName(proguardClass, proguardClass));
                    continue;
                }
                if (!StringsKt.startsWith$default((String)it, (String)this.keyOfPrefixProguardPackage, (boolean)false, (int)2, null)) continue;
                String proguardPackage = StringsKt.replace$default((String)it, (String)this.keyOfPrefixProguardPackage, (String)"", (boolean)false, (int)4, null);
                this.blockSet.add(processor.proguardPackageName(proguardPackage, proguardPackage));
            }
        }
        PluginLog.INSTANCE.debug("TraceConfiguration", "[parseBlockFile] blockSet : " + this.blockSet, new Object[0]);
        return this.blockSet.size();
    }

    @NotNull
    public String toString() {
        return "\n# Configuration\n|* packageName:\t" + this.packageName + "\n|* mappingDir:\t" + this.mappingDir + "\n|* baseMethodMapPath:\t" + this.baseMethodMapPath + "\n|* methodMapFilePath:\t" + this.methodMapFilePath + "\n|* ignoreMethodMapFilePath:\t" + this.ignoreMethodMapFilePath + "\n|* blockListFilePath:\t" + this.blockListFilePath + "\n|* traceClassOut:\t" + this.traceClassOut + "\n";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0017\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration$Builder;", "", "()V", "baseMethodMap", "", "blockListFile", "ignoreMethodMapFile", "mappingPath", "methodMapFile", "packageName", "skipCheckClass", "", "traceClassOut", "build", "Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;", "setBaseMethodMap", "setBlockListFile", "setIgnoreMethodMapFilePath", "methodMapDir", "setMappingPath", "setMethodMapFilePath", "setPackageName", "setSkipCheckClass", "setTraceClassOut", "apm-plugin"})
    public static final class Builder {
        @Nullable
        private String packageName;
        @NotNull
        private String mappingPath = "";
        @NotNull
        private String baseMethodMap = "";
        @NotNull
        private String methodMapFile = "";
        @NotNull
        private String ignoreMethodMapFile = "";
        @NotNull
        private String blockListFile = "";
        @NotNull
        private String traceClassOut = "";
        private boolean skipCheckClass;

        @NotNull
        public final Builder setPackageName(@NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            this.packageName = packageName;
            return this;
        }

        @NotNull
        public final Builder setMappingPath(@NotNull String mappingPath) {
            Intrinsics.checkNotNullParameter((Object)mappingPath, (String)"mappingPath");
            this.mappingPath = Util.INSTANCE.nullAsNil(mappingPath);
            return this;
        }

        @NotNull
        public final Builder setBaseMethodMap(@Nullable String baseMethodMap) {
            String string = baseMethodMap;
            if (string == null) {
                string = "";
            }
            this.baseMethodMap = string;
            return this;
        }

        @NotNull
        public final Builder setTraceClassOut(@Nullable String traceClassOut) {
            String string = traceClassOut;
            if (string == null) {
                string = "";
            }
            this.traceClassOut = string;
            return this;
        }

        @NotNull
        public final Builder setMethodMapFilePath(@NotNull String methodMapDir) {
            Intrinsics.checkNotNullParameter((Object)methodMapDir, (String)"methodMapDir");
            this.methodMapFile = Util.INSTANCE.nullAsNil(methodMapDir);
            return this;
        }

        @NotNull
        public final Builder setIgnoreMethodMapFilePath(@NotNull String methodMapDir) {
            Intrinsics.checkNotNullParameter((Object)methodMapDir, (String)"methodMapDir");
            this.ignoreMethodMapFile = Util.INSTANCE.nullAsNil(methodMapDir);
            return this;
        }

        @NotNull
        public final Builder setBlockListFile(@Nullable String blockListFile) {
            String string = blockListFile;
            if (string == null) {
                string = "";
            }
            this.blockListFile = string;
            return this;
        }

        @NotNull
        public final Builder setSkipCheckClass(boolean skipCheckClass) {
            this.skipCheckClass = skipCheckClass;
            return this;
        }

        @NotNull
        public final TraceConfiguration build() {
            return new TraceConfiguration(this.packageName, this.mappingPath, this.baseMethodMap, this.methodMapFile, this.ignoreMethodMapFile, this.blockListFile, this.traceClassOut, this.skipCheckClass);
        }
    }
}

