/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.cloud.apm.plugin.Const;
import com.cloud.apm.plugin.tasks.trace.Trace;
import com.cloud.apm.plugin.tasks.trace.TraceConfiguration;
import com.cloud.apm.plugin.tasks.trace.TraceUtils;
import com.cloud.apm.plugin.utils.APMPluginConfiguration;
import com.cloud.apm.plugin.utils.PluginLog;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceLegacyTransform;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "config", "Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;", "origTransform", "variant", "", "(Lorg/gradle/api/Project;Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;Lcom/android/build/api/transform/Transform;Ljava/lang/String;)V", "doTransform", "", "invocation", "Lcom/android/build/api/transform/TransformInvocation;", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "getScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "isIncremental", "", "transform", "transformInvocation", "Companion", "apm-plugin"})
public final class TraceLegacyTransform
extends Transform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final TraceConfiguration config;
    @NotNull
    private final Transform origTransform;
    @NotNull
    private final String variant;
    @NotNull
    public static final String TAG = "TraceLegacyTransform";

    public TraceLegacyTransform(@NotNull Project project, @NotNull TraceConfiguration config, @NotNull Transform origTransform, @NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)origTransform, (String)"origTransform");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.project = project;
        this.config = config;
        this.origTransform = origTransform;
        this.variant = variant;
    }

    @NotNull
    public String getName() {
        return (String)Const.INSTANCE.getGetTaskName().invoke((Object)"Trace", (Object)StringsKt.capitalize((String)this.variant));
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"CONTENT_CLASS");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set set = TransformManager.SCOPE_FULL_PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SCOPE_FULL_PROJECT");
        return set;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        super.transform(transformInvocation);
        long start = System.currentTimeMillis();
        try {
            this.doTransform(transformInvocation);
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            PluginLog.INSTANCE.printErrStackTrace(TAG, e, "[transform] do transform failed: %s", objectArray);
        }
        long mid = System.currentTimeMillis();
        this.origTransform.transform(transformInvocation);
        long end = System.currentTimeMillis();
        PluginLog.INSTANCE.info(TAG, "[transform] cost time: " + (end - start) + "ms " + this.origTransform.getClass().getSimpleName() + ": " + (end - mid) + "ms TraceTransform:" + (mid - start) + "ms", new Object[0]);
    }

    private final void doTransform(TransformInvocation invocation) {
        long start = System.currentTimeMillis();
        boolean isIncremental = invocation.isIncremental() && this.isIncremental();
        ArrayList<File> inputFiles = new ArrayList<File>();
        ConcurrentHashMap changedFiles = new ConcurrentHashMap();
        ConcurrentHashMap fileToInput = new ConcurrentHashMap();
        Collection collection = invocation.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"invocation.inputs");
        Object $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        Object[] objectArray = $this$forEach$iv.iterator();
        while (objectArray.hasNext()) {
            File file;
            DirectoryInput directoryInput;
            Map map;
            Object element$iv = objectArray.next();
            TransformInput input = (TransformInput)element$iv;
            boolean bl = false;
            Collection collection2 = input.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"input.directoryInputs");
            Iterable $this$forEach$iv2 = collection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DirectoryInput directoryInput2 = (DirectoryInput)element$iv2;
                boolean bl2 = false;
                changedFiles.putAll(directoryInput2.getChangedFiles());
                inputFiles.add(directoryInput2.getFile());
                map = fileToInput;
                Intrinsics.checkNotNullExpressionValue((Object)directoryInput2.getFile(), (String)"directoryInput.file");
                Intrinsics.checkNotNullExpressionValue((Object)directoryInput2, (String)"directoryInput");
                directoryInput = directoryInput2;
                map.put(file, directoryInput);
            }
            Collection collection3 = input.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"input.jarInputs");
            $this$forEach$iv2 = collection3;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JarInput jarInput = (JarInput)element$iv2;
                boolean bl3 = false;
                map = changedFiles;
                File file2 = jarInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"jarInput.file");
                file = file2;
                Status status = jarInput.getStatus();
                Intrinsics.checkNotNullExpressionValue((Object)status, (String)"jarInput.status");
                directoryInput = status;
                map.put(file, directoryInput);
                inputFiles.add(jarInput.getFile());
                map = fileToInput;
                File file3 = jarInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"jarInput.file");
                file = file3;
                Intrinsics.checkNotNullExpressionValue((Object)jarInput, (String)"jarInput");
                directoryInput = jarInput;
                map.put(file, directoryInput);
            }
        }
        if (inputFiles.size() == 0) {
            PluginLog.INSTANCE.info(TAG, "trace do not find any input files", new Object[0]);
            return;
        }
        String string = this.config.getBaseMethodMapPath();
        objectArray = this.config.getBlockListFilePath();
        Object object = this.config.getMappingDir();
        String string2 = this.config.getIgnoreMethodMapFilePath();
        String string3 = this.config.getMethodMapFilePath();
        Project project = this.project;
        $this$forEach$iv = new Trace(project, (String)object, string3, string, (String)objectArray, string2);
        boolean bl = this.config.getSkipCheckClass();
        objectArray = new File(this.config.getTraceClassOut());
        object = new ConcurrentHashMap();
        Trace.doTransform$default((Trace)$this$forEach$iv, isIncremental, bl, true, inputFiles, changedFiles, (Map)object, (File)objectArray, null, 128, null);
        long end = System.currentTimeMillis();
        objectArray = new Object[]{end - start};
        PluginLog.INSTANCE.info(TAG, " Insert trace instrumentations cost time: %sms.", objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceLegacyTransform$Companion;", "", "()V", "TAG", "", "getTransformTaskName", "", "customDexTransformName", "buildTypeSuffix", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "inject", "", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void inject(@NotNull Project project, @NotNull BaseVariant variant) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            String string = project.getBuildDir().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.buildDir.absolutePath");
            String string2 = variant.getDirName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.dirName");
            String mappingOut = TraceUtils.INSTANCE.getTraceMappingOut(string, string2);
            String string3 = project.getBuildDir().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.buildDir.absolutePath");
            String string4 = variant.getDirName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"variant.dirName");
            String traceClassOut = TraceUtils.INSTANCE.getTraceClassOut(string3, string4);
            PluginLog.INSTANCE.info("TraceFile", "mappingOut dir is: " + mappingOut, new Object[0]);
            TraceConfiguration.Builder builder = new TraceConfiguration.Builder();
            String string5 = variant.getApplicationId();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"variant.applicationId");
            TraceConfiguration config = builder.setPackageName(string5).setMethodMapFilePath(mappingOut + "/methodMapping.txt").setIgnoreMethodMapFilePath(mappingOut + "/ignoreMethodMapping.txt").setMappingPath(mappingOut).setBlockListFile(APMPluginConfiguration.Companion.getInstance().getTrace().getBlockListFilePath()).setTraceClassOut(traceClassOut).build();
            String string6 = variant.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"variant.name");
            String[] hardTask = this.getTransformTaskName(null, string6);
            block0: for (Task task : project.getTasks()) {
                for (String str : hardTask) {
                    if (!StringsKt.equals((String)task.getName(), (String)str, (boolean)true) || !(task instanceof TransformTask)) continue;
                    Object[] objectArray = new Object[]{((TransformTask)task).getName()};
                    PluginLog.INSTANCE.info(TraceLegacyTransform.TAG, "successfully inject task: %s", objectArray);
                    Field field = TransformTask.class.getDeclaredField("transform");
                    field.setAccessible(true);
                    Transform transform2 = ((TransformTask)task).getTransform();
                    Intrinsics.checkNotNullExpressionValue((Object)transform2, (String)"task.transform");
                    String string7 = variant.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"variant.name");
                    field.set(task, (Object)new TraceLegacyTransform(project, config, transform2, string7));
                    continue block0;
                }
            }
        }

        private final String[] getTransformTaskName(String customDexTransformName, String buildTypeSuffix) {
            String[] stringArray;
            String[] stringArray2 = (String[])customDexTransformName;
            if (!(stringArray2 == null || stringArray2.length() == 0)) {
                stringArray2 = new String[]{customDexTransformName + "For" + buildTypeSuffix};
                stringArray = stringArray2;
            } else {
                stringArray2 = new String[]{"transformClassesWithDexBuilderFor" + buildTypeSuffix, "transformClassesWithDexFor" + buildTypeSuffix};
                stringArray = stringArray2;
            }
            return stringArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

