/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace;

import com.android.build.api.transform.Status;
import com.android.build.gradle.internal.tasks.DexArchiveBuilderTask;
import com.cloud.apm.plugin.Const;
import com.cloud.apm.plugin.tasks.trace.BaseCreationAction;
import com.cloud.apm.plugin.tasks.trace.CreationConfig;
import com.cloud.apm.plugin.tasks.trace.Trace;
import com.cloud.apm.plugin.tasks.trace.TraceUtils;
import com.cloud.apm.plugin.utils.APMPluginConfiguration;
import com.cloud.apm.plugin.utils.PluginLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileType;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0016\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u001a\u0010\u0003\u001a\u00020\u00048gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u00048gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\r8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u00138gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\r8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011\u00a8\u0006&"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceTask;", "Lorg/gradle/api/DefaultTask;", "()V", "classInputs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassInputs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "setClassInputs", "(Lorg/gradle/api/file/ConfigurableFileCollection;)V", "classOutputs", "getClassOutputs", "setClassOutputs", "mappingDir", "", "getMappingDir", "()Ljava/lang/String;", "setMappingDir", "(Ljava/lang/String;)V", "skipCheckClass", "", "getSkipCheckClass", "()Z", "setSkipCheckClass", "(Z)V", "traceClassOutputDirectory", "getTraceClassOutputDirectory", "setTraceClassOutputDirectory", "execute", "", "changes", "Lorg/gradle/work/InputChanges;", "wired", "creationConfig", "Lcom/cloud/apm/plugin/tasks/trace/CreationConfig;", "task", "Lcom/android/build/gradle/internal/tasks/DexArchiveBuilderTask;", "Companion", "CreationAction", "apm-plugin"})
public abstract class TraceTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "TraceTask";

    @Incremental
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getClassInputs();

    public abstract void setClassInputs(@NotNull ConfigurableFileCollection var1);

    @Input
    @Optional
    @NotNull
    public abstract String getMappingDir();

    public abstract void setMappingDir(@NotNull String var1);

    @Input
    @NotNull
    public abstract String getTraceClassOutputDirectory();

    public abstract void setTraceClassOutputDirectory(@NotNull String var1);

    @OutputFiles
    @NotNull
    public abstract ConfigurableFileCollection getClassOutputs();

    public abstract void setClassOutputs(@NotNull ConfigurableFileCollection var1);

    @Optional
    public abstract boolean getSkipCheckClass();

    public abstract void setSkipCheckClass(boolean var1);

    @TaskAction
    public final void execute(@NotNull InputChanges changes) {
        String string;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        ConcurrentHashMap changedMap = new ConcurrentHashMap();
        boolean incremental = changes.isIncremental();
        if (incremental) {
            Iterable iterable = changes.getFileChanges((FileCollection)this.getClassInputs());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"changes.getFileChanges(classInputs)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Status status;
                FileChange change = (FileChange)element$iv;
                boolean bl = false;
                if (change.getFileType() == FileType.DIRECTORY) continue;
                object2 = changedMap;
                Intrinsics.checkNotNullExpressionValue((Object)change.getFile(), (String)"change.file");
                ChangeType changeType = change.getChangeType();
                switch (changeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[changeType.ordinal()]) {
                    case 1: {
                        status = Status.REMOVED;
                        break;
                    }
                    case 2: {
                        status = Status.CHANGED;
                        break;
                    }
                    case 3: {
                        status = Status.ADDED;
                        break;
                    }
                    default: {
                        status = Status.NOTCHANGED;
                    }
                }
                object = status;
                object2.put(string, object);
            }
        }
        long start = System.currentTimeMillis();
        File outputDirectory = new File(this.getTraceClassOutputDirectory());
        String ignoreMethodMapFilePath = this.getMappingDir() + "/ignoreMethodMapping.txt";
        String methodMapFilePath = this.getMappingDir() + "/methodMapping.txt";
        try {
            object2 = APMPluginConfiguration.Companion.getInstance().getTrace().getBlockListFilePath();
            string = this.getMappingDir();
            object = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project");
            Trace bl = new Trace((Project)object, string, methodMapFilePath, "", (String)object2, ignoreMethodMapFilePath);
            object2 = this.getClassInputs().getFiles();
            boolean bl2 = this.getSkipCheckClass();
            object = new ConcurrentHashMap();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"files");
            Trace.doTransform$default(bl, incremental, bl2, false, (Collection)object2, changedMap, (Map)object, outputDirectory, null, 128, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        Object[] objectArray = new Object[]{end - start};
        PluginLog.INSTANCE.info(TAG, " Insert trace instrumentations cost time: %sms.", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void wired(@NotNull CreationConfig creationConfig, @NotNull DexArchiveBuilderTask task) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        PluginLog.INSTANCE.info(TAG, "Wiring " + this.getName() + " to task '" + task.getName() + "'.", new Object[0]);
        Object[] objectArray = new Object[]{this};
        task.dependsOn(objectArray);
        this.getClassInputs().setFrom((Iterable)task.getMixedScopeClasses().getFiles());
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String traceClassOut = Companion.getTraceClassOut(project, creationConfig);
        Set set = task.getMixedScopeClasses().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"task.mixedScopeClasses.files");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new File(traceClassOut, Trace.Companion.appendSuffix((File)it, "traced")));
        }
        List outputs = (List)destination$iv$iv;
        Object[] objectArray2 = new Object[]{outputs};
        this.getClassOutputs().from(objectArray2);
        task.getMixedScopeClasses().setFrom((Iterable)this.getClassOutputs());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceTask$Companion;", "", "()V", "TAG", "", "getTraceClassOut", "project", "Lorg/gradle/api/Project;", "creationConfig", "Lcom/cloud/apm/plugin/tasks/trace/CreationConfig;", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTraceClassOut(@NotNull Project project, @NotNull CreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            String string = project.getBuildDir().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.buildDir.toString()");
            return TraceUtils.INSTANCE.getTraceClassOut(string, creationConfig.getDirName());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceTask$CreationAction;", "Lorg/gradle/api/Action;", "Lcom/cloud/apm/plugin/tasks/trace/TraceTask;", "Lcom/cloud/apm/plugin/tasks/trace/BaseCreationAction;", "creationConfig", "Lcom/cloud/apm/plugin/tasks/trace/CreationConfig;", "(Lcom/cloud/apm/plugin/tasks/trace/CreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "execute", "", "task", "apm-plugin"})
    public static final class CreationAction
    extends BaseCreationAction<TraceTask>
    implements Action<TraceTask> {
        @NotNull
        private final CreationConfig creationConfig;
        @NotNull
        private final String name;
        @NotNull
        private final Class<TraceTask> type;

        public CreationAction(@NotNull CreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this.creationConfig = creationConfig;
            this.name = (String)Const.INSTANCE.getGetTaskName().invoke((Object)"Trace", (Object)StringsKt.capitalize((String)this.creationConfig.getName()));
            this.type = TraceTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<TraceTask> getType() {
            return this.type;
        }

        public void execute(@NotNull TraceTask task) {
            Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
            Project project = this.creationConfig.getProject();
            String variantDirName = this.creationConfig.getDirName();
            String string = project.getBuildDir().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.buildDir.toString()");
            String mappingOut = TraceUtils.INSTANCE.getTraceMappingOut(string, variantDirName);
            String traceClassOut = Companion.getTraceClassOut(project, this.creationConfig);
            PluginLog.INSTANCE.info("TraceFile", "mappingOut dir is: " + mappingOut, new Object[0]);
            task.setMappingDir(mappingOut);
            task.setTraceClassOutputDirectory(traceClassOut);
            task.setSkipCheckClass(true);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChangeType.values().length];
            nArray[ChangeType.REMOVED.ordinal()] = 1;
            nArray[ChangeType.MODIFIED.ordinal()] = 2;
            nArray[ChangeType.ADDED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

