/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lcom/cloud/apm/plugin/utils/Util;", "", "()V", "byteArrayToHex", "", "data", "", "capitalize", "word", "formatByteUnit", "bytes", "", "nullAsNil", "str", "preventZipSlip", "", "output", "Ljava/io/File;", "zipEntryName", "apm-plugin"})
public final class Util {
    @NotNull
    public static final Util INSTANCE = new Util();

    private Util() {
    }

    @NotNull
    public final String nullAsNil(@Nullable String str) {
        String string = str;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final boolean preventZipSlip(@NotNull File output, @NotNull String zipEntryName) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)zipEntryName, (String)"zipEntryName");
        try {
            if (StringsKt.contains$default((CharSequence)zipEntryName, (CharSequence)"..", (boolean)false, (int)2, null)) {
                String string = new File(output, zipEntryName).getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(output, zipEntryNam\u2026           .canonicalPath");
                if (StringsKt.startsWith$default((String)string, (String)(output.getCanonicalPath() + File.separator), (boolean)false, (int)2, null)) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    @NotNull
    public final String byteArrayToHex(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] hexDigits = cArray;
        char[] str = new char[data.length * 2];
        int k = 0;
        for (byte byte0 : data) {
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return str.toString();
    }

    @NotNull
    public final String formatByteUnit(long bytes) {
        String string;
        if (bytes >= 0x100000L) {
            String string2 = "%.2fMB";
            Object[] objectArray = new Object[]{(double)bytes / 1048576.0};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        } else if (bytes >= 1024L) {
            String string4 = "%.2fKB";
            Object[] objectArray = new Object[]{(double)bytes / 1024.0};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        } else {
            String string6 = "%dBytes";
            Object[] objectArray = new Object[]{bytes};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
        }
        return string;
    }

    @NotNull
    public final String capitalize(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (((CharSequence)word).length() == 0) {
            return word;
        }
        char upperChar = Character.toUpperCase(word.charAt(0));
        String string = word.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return upperChar + string;
    }
}

