/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace;

import com.android.build.api.transform.Status;
import com.cloud.apm.plugin.tasks.trace.Trace;
import com.cloud.apm.plugin.tasks.trace.TraceArtifactTask;
import com.cloud.apm.plugin.transform.CommonArtifactTask;
import com.cloud.apm.plugin.utils.APMPluginConfiguration;
import com.cloud.apm.plugin.utils.FileUtil;
import com.cloud.apm.plugin.utils.PluginLog;
import com.cloud.apm.plugin.utils.TransformUtilKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b'\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0013H\u0016J@\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0019\u001a\u00020\u00062\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001bH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\n8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\n8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceArtifactTask;", "Lcom/cloud/apm/plugin/transform/CommonArtifactTask;", "", "()V", "changedMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/io/File;", "Lcom/android/build/api/transform/Status;", "inputToOutput", "mappingDir", "", "getMappingDir", "()Ljava/lang/String;", "setMappingDir", "(Ljava/lang/String;)V", "traceClassOutputDirectory", "getTraceClassOutputDirectory", "setTraceClassOutputDirectory", "execute", "", "onDoTransform", "polymerizeOutputs", "dirs", "", "jars", "output", "inToOutMap", "", "Companion", "apm-plugin"})
public abstract class TraceArtifactTask
extends CommonArtifactTask<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<File, Status> changedMap = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<File, File> inputToOutput = new ConcurrentHashMap();
    @NotNull
    private static final String TAG = "TraceArtifactTask";

    @Input
    @NotNull
    public abstract String getMappingDir();

    public abstract void setMappingDir(@NotNull String var1);

    @Input
    @NotNull
    public abstract String getTraceClassOutputDirectory();

    public abstract void setTraceClassOutputDirectory(@NotNull String var1);

    @Override
    @TaskAction
    public void execute() {
        long start = System.currentTimeMillis();
        super.execute();
        long end = System.currentTimeMillis();
        Object[] objectArray = new Object[]{end - start};
        PluginLog.INSTANCE.info(TAG, " Insert trace instrumentations cost time: %sms.", objectArray);
    }

    @Override
    public void onDoTransform() {
        String mappingOut = this.getMappingDir();
        String traceClassOut = this.getTraceClassOutputDirectory();
        String ignoreMethodMapFilePath = mappingOut + "/ignoreMethodMapping.txt";
        String methodMapFilePath = mappingOut + "/methodMapping.txt";
        File outputDirectory = new File(traceClassOut);
        Function2 postProcessBlock2 = (Function2)new Function2<Map<File, ? extends File>, ExecutorService, Unit>(this){
            final /* synthetic */ TraceArtifactTask this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Map<File, ? extends File> inToOutMap, @NotNull ExecutorService executor2) {
                Intrinsics.checkNotNullParameter(inToOutMap, (String)"inToOutMap");
                Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
                Collection<File> collection = this.this$0.compileClassInputs();
                File file = ((RegularFile)this.this$0.getOutput().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"output.get().asFile");
                this.this$0.aggregateOutputs(collection, file, executor2, (Function1<byte[], byte[]>)((Function1)onDoTransform.postProcessBlock.1.INSTANCE), inToOutMap);
            }
        };
        Object object = APMPluginConfiguration.Companion.getInstance().getTrace().getBlockListFilePath();
        Object object2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project");
        Trace trace = new Trace((Project)object2, mappingOut, methodMapFilePath, "", (String)object, ignoreMethodMapFilePath);
        object = this.compileClassInputs();
        object2 = this.changedMap;
        ConcurrentHashMap<File, File> concurrentHashMap = this.inputToOutput;
        trace.doTransform(false, true, true, (Collection<? extends File>)object, (Map)object2, (Map<File, ? extends File>)concurrentHashMap, outputDirectory, (Function2<? super Map<File, ? extends File>, ? super ExecutorService, Unit>)postProcessBlock2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void polymerizeOutputs(Collection<? extends File> dirs, Collection<? extends File> jars, File output, Map<File, ? extends File> inToOutMap) {
        Closeable closeable = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(output)));
        Throwable throwable = null;
        try {
            File file;
            File it;
            JarOutputStream jarOutput = (JarOutputStream)closeable;
            boolean bl = false;
            String outputPath = output.getAbsolutePath();
            Iterable $this$forEach$iv = dirs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File outDir;
                it = (File)element$iv;
                boolean bl2 = false;
                if (inToOutMap.get(it) == null) continue;
                PluginLog.INSTANCE.debug(TAG, outDir.getAbsolutePath() + " will copyTo " + outputPath, new Object[0]);
                Sequence $this$forEach$iv2 = (Sequence)FilesKt.walk$default((File)outDir, null, (int)1, null);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    file = (File)element$iv2;
                    boolean bl3 = false;
                    if (!file.isFile()) continue;
                    String relativePath = outDir.toURI().relativize(file.toURI()).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)relativePath, (String)"relativePath");
                    String targetPath = StringsKt.replace$default((String)relativePath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                    PluginLog.INSTANCE.debug(TAG, file.toURI() + " from " + relativePath + " to " + targetPath, new Object[0]);
                    JarEntry targetZipEntry = new JarEntry(targetPath);
                    FileUtil.INSTANCE.addZipEntry(jarOutput, targetZipEntry, new FileInputStream(file));
                }
            }
            $this$forEach$iv = jars;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File outJar;
                it = (File)element$iv;
                boolean bl4 = false;
                if (inToOutMap.get(it) == null) continue;
                PluginLog.INSTANCE.debug(TAG, outJar.getAbsolutePath() + " will copyTo " + outputPath, new Object[0]);
                Closeable closeable2 = new JarFile(outJar);
                Throwable throwable2 = null;
                try {
                    void $this$forEach$iv3;
                    JarFile jarFile = (JarFile)closeable2;
                    boolean bl5 = false;
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile.entries()");
                    file = SequencesKt.filterNot((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)polymerizeOutputs.1.2.1.1.INSTANCE);
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        Object object;
                        JarEntry jarEntry = (JarEntry)element$iv3;
                        boolean bl6 = false;
                        if (jarEntry.isDirectory()) continue;
                        String string = jarEntry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarEntry.name");
                        if (TransformUtilKt.isJarSignatureRelatedFiles(string)) continue;
                        Object object2 = this;
                        try {
                            long l;
                            TraceArtifactTask $this$polymerizeOutputs_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d3 = object2;
                            boolean bl7 = false;
                            jarOutput.putNextEntry(new JarEntry(jarEntry.getName()));
                            Closeable closeable3 = jarFile.getInputStream(jarEntry);
                            Throwable throwable3 = null;
                            try {
                                InputStream stream = (InputStream)closeable3;
                                boolean bl8 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
                                l = ByteStreamsKt.copyTo$default((InputStream)stream, (OutputStream)jarOutput, (int)0, (int)2, null);
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                            }
                            object = Result.constructor-impl((Object)l);
                        }
                        catch (Throwable bl7) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl7));
                        }
                        object2 = object;
                        Throwable throwable5 = Result.exceptionOrNull-impl((Object)object2);
                        if (throwable5 != null) {
                            Object e = object = throwable5;
                            boolean bl9 = false;
                            PluginLog.INSTANCE.error(TAG, "Copy jar entry " + jarEntry.getName() + " failed. : " + (Throwable)e, new Object[0]);
                        }
                        jarOutput.closeEntry();
                    }
                    Iterator iterator = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                PluginLog.INSTANCE.debug(TAG, outJar.getAbsolutePath() + " did copyTo " + outputPath, new Object[0]);
            }
            jarOutput.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable7) {
            throwable = throwable7;
            throw throwable7;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceArtifactTask$Companion;", "", "()V", "TAG", "", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

