/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace.methodTrace;

import com.cloud.apm.plugin.Const;
import com.cloud.apm.plugin.tasks.trace.TraceConfiguration;
import com.cloud.apm.plugin.tasks.trace.mapping.MappingCollector;
import com.cloud.apm.plugin.tasks.trace.methodTrace.AgpCompat;
import com.cloud.apm.plugin.tasks.trace.methodTrace.MethodCollector;
import com.cloud.apm.plugin.tasks.trace.methodTrace.TraceMethod;
import com.cloud.apm.plugin.utils.FileUtil;
import com.cloud.apm.plugin.utils.PluginLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 62\u00020\u0001:\u000534567B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J(\u0010\u001c\u001a\u00020\u00172\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u001ej\b\u0012\u0004\u0012\u00020\u001a`\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0002J(\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J(\u0010%\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002Jn\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0$2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\f28\b\u0002\u0010*\u001a2\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b,\u0012\b\b-\u0012\u0004\b\b(.\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b,\u0012\b\b-\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020\u00170+H\u0002J\u0012\u00101\u001a\u00020\u00172\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u00102\u001a\u00020\u00172\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002R\u001f\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodCollector;", "", "executor", "Ljava/util/concurrent/ExecutorService;", "mappingCollector", "Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector;", "methodId", "Ljava/util/concurrent/atomic/AtomicInteger;", "configuration", "Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;", "collectedMethodMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/cloud/apm/plugin/tasks/trace/methodTrace/TraceMethod;", "(Ljava/util/concurrent/ExecutorService;Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector;Ljava/util/concurrent/atomic/AtomicInteger;Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;Ljava/util/concurrent/ConcurrentHashMap;)V", "collectedClassExtendMap", "getCollectedClassExtendMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "collectedIgnoreMethodMap", "getCollectedMethodMap", "ignoreCount", "incrementCount", "collect", "", "srcFolderList", "", "Ljava/io/File;", "dependencyJarList", "listClassFiles", "classFiles", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "folder", "printCollectedMethods", "methodFile", "ignoreMethodList", "", "printIgnoreCollectedMethods", "printMethods", "methodMapFile", "methodList", "title", "writeAction", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "method", "Ljava/io/PrintWriter;", "pw", "saveCollectedMethod", "saveIgnoreCollectedMethod", "CollectJarTask", "CollectMethodNode", "CollectSourceTask", "Companion", "TraceClassAdapter", "apm-plugin"})
public final class MethodCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final MappingCollector mappingCollector;
    @NotNull
    private final AtomicInteger methodId;
    @NotNull
    private final TraceConfiguration configuration;
    @NotNull
    private final ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
    @NotNull
    private final ConcurrentHashMap<String, String> collectedClassExtendMap;
    @NotNull
    private final ConcurrentHashMap<String, TraceMethod> collectedIgnoreMethodMap;
    @NotNull
    private final AtomicInteger ignoreCount;
    @NotNull
    private final AtomicInteger incrementCount;
    @NotNull
    private static final String TAG = "MethodCollector";

    public MethodCollector(@NotNull ExecutorService executor2, @NotNull MappingCollector mappingCollector, @NotNull AtomicInteger methodId, @NotNull TraceConfiguration configuration, @NotNull ConcurrentHashMap<String, TraceMethod> collectedMethodMap) {
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)mappingCollector, (String)"mappingCollector");
        Intrinsics.checkNotNullParameter((Object)methodId, (String)"methodId");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(collectedMethodMap, (String)"collectedMethodMap");
        this.executor = executor2;
        this.mappingCollector = mappingCollector;
        this.methodId = methodId;
        this.configuration = configuration;
        this.collectedMethodMap = collectedMethodMap;
        this.collectedClassExtendMap = new ConcurrentHashMap();
        this.collectedIgnoreMethodMap = new ConcurrentHashMap();
        this.ignoreCount = new AtomicInteger();
        this.incrementCount = new AtomicInteger();
    }

    @NotNull
    public final ConcurrentHashMap<String, TraceMethod> getCollectedMethodMap() {
        return this.collectedMethodMap;
    }

    @NotNull
    public final ConcurrentHashMap<String, String> getCollectedClassExtendMap() {
        return this.collectedClassExtendMap;
    }

    public final void collect(@NotNull Set<? extends File> srcFolderList, @NotNull Set<? extends File> dependencyJarList) {
        File it;
        Intrinsics.checkNotNullParameter(srcFolderList, (String)"srcFolderList");
        Intrinsics.checkNotNullParameter(dependencyJarList, (String)"dependencyJarList");
        List futures = new LinkedList();
        Iterable $this$forEach$iv = srcFolderList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl = false;
            ArrayList<File> classFileList = new ArrayList<File>();
            if (it.isDirectory()) {
                this.listClassFiles(classFileList, it);
            } else {
                classFileList.add(it);
            }
            Iterable $this$forEach$iv2 = classFileList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File classFile = (File)element$iv2;
                boolean bl2 = false;
                Future<?> future = this.executor.submit(new CollectSourceTask(classFile));
                Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit(CollectSourceTask(classFile))");
                futures.add(future);
            }
        }
        $this$forEach$iv = dependencyJarList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl = false;
            Future<?> future = this.executor.submit(new CollectJarTask(it));
            Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit(CollectJarTask(it))");
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        futures.clear();
        Future<?> future = this.executor.submit(() -> MethodCollector.collect$lambda-3(this));
        Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit { saveIg\u2026ethod(mappingCollector) }");
        futures.add(future);
        Future<?> future2 = this.executor.submit(() -> MethodCollector.collect$lambda-4(this));
        Intrinsics.checkNotNullExpressionValue(future2, (String)"executor.submit { saveCo\u2026ethod(mappingCollector) }");
        futures.add(future2);
        for (Future future3 : futures) {
            future3.get();
        }
        futures.clear();
    }

    private final void saveIgnoreCollectedMethod(MappingCollector mappingCollector) {
        File methodMapFile = new File(this.configuration.getIgnoreMethodMapFilePath());
        if (!methodMapFile.getParentFile().exists()) {
            methodMapFile.getParentFile().mkdirs();
        }
        List ignoreMethodList = new ArrayList();
        Collection<TraceMethod> collection = this.collectedIgnoreMethodMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"collectedIgnoreMethodMap.values");
        ignoreMethodList.addAll(collection);
        Object[] objectArray = new Object[]{this.collectedIgnoreMethodMap.size(), methodMapFile.getAbsolutePath()};
        PluginLog.INSTANCE.info(TAG, "[saveIgnoreCollectedMethod] size:%s path: %s", objectArray);
        CollectionsKt.sortWith((List)ignoreMethodList, MethodCollector::saveIgnoreCollectedMethod$lambda-5);
        this.printIgnoreCollectedMethods(methodMapFile, ignoreMethodList, mappingCollector);
    }

    private final void printIgnoreCollectedMethods(File methodFile, List<TraceMethod> ignoreMethodList, MappingCollector mappingCollector) {
        this.printMethods(methodFile, ignoreMethodList, mappingCollector, "ignore methods: ", (Function2<? super TraceMethod, ? super PrintWriter, Unit>)((Function2)printIgnoreCollectedMethods.1.INSTANCE));
    }

    private final void printCollectedMethods(File methodFile, List<TraceMethod> ignoreMethodList, MappingCollector mappingCollector) {
        this.printMethods(methodFile, ignoreMethodList, mappingCollector, "", (Function2<? super TraceMethod, ? super PrintWriter, Unit>)((Function2)printCollectedMethods.1.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printMethods(File methodMapFile, List<TraceMethod> methodList, MappingCollector mappingCollector, String title, Function2<? super TraceMethod, ? super PrintWriter, Unit> writeAction) {
        PrintWriter printWriter = null;
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter writer = null;
        try {
            fileOutputStream = new FileOutputStream(methodMapFile, false);
            writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            printWriter = new PrintWriter(writer);
            CharSequence charSequence = title;
            if (!(charSequence == null || charSequence.length() == 0)) {
                printWriter.println(title);
            }
            for (TraceMethod traceMethod : methodList) {
                traceMethod.revert(mappingCollector);
                writeAction.invoke((Object)traceMethod, (Object)printWriter);
            }
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            PluginLog.INSTANCE.printErrStackTrace(TAG, e, "write method map Exception :%s", objectArray);
        }
        finally {
            FileUtil.INSTANCE.flushQuietly(printWriter);
            FileUtil.INSTANCE.closeQuietly(printWriter);
            FileUtil.INSTANCE.closeQuietly(fileOutputStream);
        }
    }

    static /* synthetic */ void printMethods$default(MethodCollector methodCollector, File file, List list, MappingCollector mappingCollector, String string, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            function2 = printMethods.1.INSTANCE;
        }
        methodCollector.printMethods(file, list, mappingCollector, string, (Function2<? super TraceMethod, ? super PrintWriter, Unit>)function2);
    }

    private final void saveCollectedMethod(MappingCollector mappingCollector) {
        File methodMapFile = new File(this.configuration.getMethodMapFilePath());
        if (!methodMapFile.getParentFile().exists()) {
            methodMapFile.getParentFile().mkdirs();
        }
        List methodList = new ArrayList();
        TraceMethod extra = TraceMethod.Companion.create(1048574, 1, "android.os.Handler", "dispatchMessage", "(Landroid.os.Message;)V");
        ((Map)this.collectedMethodMap).put(extra.getRealMethodName(), extra);
        Collection<TraceMethod> collection = this.collectedMethodMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"this@MethodCollector.collectedMethodMap.values");
        methodList.addAll(collection);
        Object[] objectArray = new Object[]{this.collectedMethodMap.size(), this.incrementCount.get(), methodMapFile.getAbsolutePath()};
        PluginLog.INSTANCE.info(TAG, "[saveCollectedMethod] size:%s incrementCount:%s path: %s", objectArray);
        CollectionsKt.sortWith((List)methodList, MethodCollector::saveCollectedMethod$lambda-6);
        this.printCollectedMethods(methodMapFile, methodList, mappingCollector);
    }

    private final void listClassFiles(ArrayList<File> classFiles, File folder) {
        File[] files = folder.listFiles();
        if (files == null) {
            Object[] objectArray = new Object[]{folder.getAbsolutePath()};
            PluginLog.INSTANCE.error(TAG, "[listClassFiles] folder's listFiles is null! %s", objectArray);
            return;
        }
        File[] $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File file = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (file == null) continue;
            if (file.isDirectory()) {
                this.listClassFiles(classFiles, file);
                continue;
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (!Companion.isNeedTraceFile(string)) continue;
            classFiles.add(file);
        }
    }

    private static final void collect$lambda-3(MethodCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.saveIgnoreCollectedMethod(this$0.mappingCollector);
    }

    private static final void collect$lambda-4(MethodCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.saveCollectedMethod(this$0.mappingCollector);
    }

    private static final int saveIgnoreCollectedMethod$lambda-5(TraceMethod o1, TraceMethod o2) {
        return o1.getClassName().compareTo(o2.getClassName());
    }

    private static final int saveCollectedMethod$lambda-6(TraceMethod o1, TraceMethod o2) {
        return o1.getId() - o2.getId();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004J\u001a\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodCollector$Companion;", "", "()V", "TAG", "", "isNeedTrace", "", "configuration", "Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;", "clsName", "mappingCollector", "Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector;", "isNeedTraceFile", "fileName", "isWindowFocusChangeMethod", "name", "desc", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isNeedTraceFile(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            if (StringsKt.endsWith$default((String)fileName, (String)".class", (boolean)false, (int)2, null)) {
                for (String unTraceCls : Const.INSTANCE.getUN_TRACE_CLASS()) {
                    if (!StringsKt.contains$default((CharSequence)fileName, (CharSequence)unTraceCls, (boolean)false, (int)2, null)) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        public final boolean isNeedTrace(@NotNull TraceConfiguration configuration, @NotNull String clsName, @Nullable MappingCollector mappingCollector) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)clsName, (String)"clsName");
            String newClsName = clsName;
            boolean isNeed = true;
            if (configuration.getBlockSet().contains(newClsName)) {
                isNeed = false;
            } else {
                if (mappingCollector != null) {
                    newClsName = mappingCollector.originalClassName(newClsName, newClsName);
                }
                CharSequence charSequence = newClsName;
                Regex regex = new Regex("/");
                CharSequence charSequence2 = ".";
                newClsName = regex.replace(charSequence, charSequence2);
                for (String packageName : configuration.getBlockSet()) {
                    Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
                    Regex regex2 = new Regex("/");
                    charSequence2 = packageName;
                    String string = ".";
                    if (!StringsKt.startsWith$default((String)newClsName, (String)regex2.replace(charSequence2, string), (boolean)false, (int)2, null)) continue;
                    isNeed = false;
                    break;
                }
            }
            return isNeed;
        }

        public final boolean isWindowFocusChangeMethod(@Nullable String name, @Nullable String desc) {
            return name != null && desc != null && Intrinsics.areEqual((Object)name, (Object)"onWindowFocusChanged") && Intrinsics.areEqual((Object)desc, (Object)"(Z)V");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodCollector$CollectSourceTask;", "Ljava/lang/Runnable;", "classFile", "Ljava/io/File;", "(Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodCollector;Ljava/io/File;)V", "run", "", "apm-plugin"})
    public final class CollectSourceTask
    implements Runnable {
        @NotNull
        private File classFile;

        public CollectSourceTask(File classFile) {
            Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
            this.classFile = classFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.classFile);
                ClassReader classReader = new ClassReader((InputStream)fileInputStream);
                TraceClassAdapter visitor = new TraceClassAdapter(AgpCompat.INSTANCE.getAsmApi(), (ClassVisitor)new ClassWriter(1));
                classReader.accept((ClassVisitor)visitor, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                FileUtil.INSTANCE.closeQuietly(fileInputStream);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodCollector$CollectJarTask;", "Ljava/lang/Runnable;", "jarFile", "Ljava/io/File;", "(Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodCollector;Ljava/io/File;)V", "run", "", "apm-plugin"})
    public final class CollectJarTask
    implements Runnable {
        @NotNull
        private final File jarFile;

        public CollectJarTask(File jarFile) {
            Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
            this.jarFile = jarFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.jarFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    String zipEntryName = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)zipEntryName, (String)"zipEntryName");
                    if (!Companion.isNeedTraceFile(zipEntryName)) continue;
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    ClassReader classReader = new ClassReader(inputStream);
                    ClassWriter classWriter = new ClassWriter(1);
                    ClassVisitor visitor = new TraceClassAdapter(AgpCompat.INSTANCE.getAsmApi(), (ClassVisitor)classWriter);
                    classReader.accept(visitor, 0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                FileUtil.INSTANCE.closeQuietly(zipFile);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0096\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005JG\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J?\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodCollector$TraceClassAdapter;", "Lorg/objectweb/asm/ClassVisitor;", "api", "", "classVisitor", "(Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodCollector;ILorg/objectweb/asm/ClassVisitor;)V", "className", "", "hasWindowFocusMethod", "", "isABSClass", "visit", "", "version", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "desc", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "apm-plugin"})
    public class TraceClassAdapter
    extends ClassVisitor {
        private String className;
        private boolean isABSClass;
        private boolean hasWindowFocusMethod;

        public TraceClassAdapter(@Nullable int api, ClassVisitor classVisitor) {
            super(api, classVisitor);
        }

        public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @NotNull String[] interfaces) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)interfaces, (String)"interfaces");
                super.visit(version, access, name, signature, superName, interfaces);
                this.className = name;
                if ((access & 0x400) > 0 || (access & 0x200) > 0) {
                    this.isABSClass = true;
                }
                String string = superName;
                if (string == null) break block2;
                String string2 = string;
                MethodCollector methodCollector = MethodCollector.this;
                String $this$visit_u24lambda_u2d0 = string2;
                boolean bl = false;
                Map map = methodCollector.getCollectedClassExtendMap();
                String string3 = this.className;
                if (string3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"className");
                    string3 = null;
                }
                map.put(string3, superName);
            }
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor methodVisitor;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            if (this.isABSClass) {
                MethodVisitor methodVisitor2 = super.visitMethod(access, name, desc, signature, exceptions);
                methodVisitor = methodVisitor2;
                Intrinsics.checkNotNullExpressionValue((Object)methodVisitor2, (String)"{\n                super.\u2026exceptions)\n            }");
            } else {
                String string;
                if (!this.hasWindowFocusMethod) {
                    this.hasWindowFocusMethod = Companion.isWindowFocusChangeMethod(name, desc);
                }
                if ((string = this.className) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"className");
                    string = null;
                }
                methodVisitor = (MethodVisitor)new CollectMethodNode(string, access, name, desc, signature, exceptions);
            }
            return methodVisitor;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodCollector$CollectMethodNode;", "Lorg/objectweb/asm/tree/MethodNode;", "className", "", "access", "", "name", "desc", "signature", "exceptions", "", "(Lcom/cloud/apm/plugin/tasks/trace/methodTrace/MethodCollector;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "isConstructor", "", "isEmptyMethod", "()Z", "isGetSetMethod", "isSingleMethod", "visitEnd", "", "apm-plugin"})
    private final class CollectMethodNode
    extends MethodNode {
        @NotNull
        private final String className;
        private boolean isConstructor;

        public CollectMethodNode(String className, @NotNull int access, @NotNull String name, @Nullable String desc, @Nullable String signature, String[] exceptions) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            super(AgpCompat.INSTANCE.getAsmApi(), access, name, desc, signature, exceptions);
            this.className = className;
        }

        public void visitEnd() {
            super.visitEnd();
            String string = this.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            String string2 = this.desc;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"desc");
            TraceMethod traceMethod = TraceMethod.Companion.create(0, this.access, this.className, string, string2);
            if (Intrinsics.areEqual((Object)"<init>", (Object)this.name)) {
                this.isConstructor = true;
            }
            boolean isNeedTrace = Companion.isNeedTrace(MethodCollector.this.configuration, traceMethod.getClassName(), MethodCollector.this.mappingCollector);
            if ((this.isEmptyMethod() || this.isGetSetMethod() || this.isSingleMethod()) && isNeedTrace) {
                MethodCollector.this.ignoreCount.incrementAndGet();
                ((Map)MethodCollector.this.collectedIgnoreMethodMap).put(traceMethod.getRealMethodName(), traceMethod);
                return;
            }
            if (isNeedTrace && !MethodCollector.this.getCollectedMethodMap().containsKey(traceMethod.getRealMethodName())) {
                traceMethod.setId(MethodCollector.this.methodId.incrementAndGet());
                ((Map)MethodCollector.this.getCollectedMethodMap()).put(traceMethod.getRealMethodName(), traceMethod);
                MethodCollector.this.incrementCount.incrementAndGet();
            } else if (!isNeedTrace && !MethodCollector.this.collectedIgnoreMethodMap.containsKey(traceMethod.getClassName())) {
                MethodCollector.this.ignoreCount.incrementAndGet();
                ((Map)MethodCollector.this.collectedIgnoreMethodMap).put(traceMethod.getRealMethodName(), traceMethod);
            }
        }

        private final boolean isGetSetMethod() {
            int count = 0;
            ListIterator listIterator = this.instructions.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)listIterator, (String)"instructions.iterator()");
            ListIterator iterator = listIterator;
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)iterator.next();
                int opcode = insnNode.getOpcode();
                if (opcode == -1 || opcode == 180 || opcode == 178 || opcode == 1 || opcode == 2 || opcode == 177 || opcode == 176 || opcode == 175 || opcode == 174 || opcode == 173 || opcode == 172 || opcode == 181 || opcode == 179 || opcode == 3 || opcode == 4 || opcode <= 53) continue;
                if (this.isConstructor && opcode == 183) {
                    if (++count <= 1) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private final boolean isSingleMethod() {
            ListIterator listIterator = this.instructions.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)listIterator, (String)"instructions.iterator()");
            ListIterator iterator = listIterator;
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)iterator.next();
                int opcode = insnNode.getOpcode();
                if (-1 == opcode || 182 > opcode || opcode > 186) continue;
                return false;
            }
            return true;
        }

        private final boolean isEmptyMethod() {
            ListIterator listIterator = this.instructions.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)listIterator, (String)"instructions.iterator()");
            ListIterator iterator = listIterator;
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)iterator.next();
                int opcode = insnNode.getOpcode();
                if (-1 == opcode) continue;
                return false;
            }
            return true;
        }
    }
}

