/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.traffic;

import com.android.build.api.transform.Transform;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.Variant;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.cloud.apm.plugin.tasks.traffic.APMTrafficTransform;
import com.cloud.apm.plugin.tasks.traffic.APMTrafficTransformClassVisitorFactoryHelper;
import com.cloud.apm.plugin.tasks.traffic.transformer.Okhttp2ClassTransformer;
import com.cloud.apm.plugin.tasks.traffic.transformer.Okhttp3ClassTransformer;
import com.cloud.apm.plugin.tasks.traffic.transformer.UrlConnectionTransformer;
import com.cloud.apm.plugin.tasks.traffic.transformer.WebViewTransformer;
import com.cloud.apm.plugin.transform.CommonTransformer;
import com.cloud.apm.plugin.transform.transformer.AbsTransformer;
import com.cloud.apm.plugin.transform.transformer.Transformer;
import com.cloud.apm.plugin.utils.AGPVersion;
import com.cloud.apm.plugin.utils.APMPluginConfiguration;
import com.cloud.apm.plugin.utils.PluginLog;
import com.cloud.apm.plugin.utils.VersionUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lcom/cloud/apm/plugin/tasks/traffic/TrafficService;", "", "()V", "appExtensionInject", "", "appExtension", "Lcom/android/build/gradle/AppExtension;", "project", "Lorg/gradle/api/Project;", "componentExtensionInject", "enableTrafficTransform", "", "inject", "Companion", "apm-plugin"})
public final class TrafficService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TAG = "TrafficService";
    @NotNull
    public static final String serviceType = "Network";

    public final void inject(@NotNull AppExtension appExtension, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)appExtension, (String)"appExtension");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.enableTrafficTransform()) {
            PluginLog.INSTANCE.info(TAG, "traffic transform was disabled", new Object[0]);
            return;
        }
        if (((Boolean)VersionUtil.INSTANCE.getLessThan().invoke((Object)AGPVersion.AGP_7_4_0)).booleanValue()) {
            this.appExtensionInject(appExtension, project);
        } else if (((Boolean)VersionUtil.INSTANCE.getGreatThanOrEqual().invoke((Object)AGPVersion.AGP_7_4_0)).booleanValue()) {
            this.componentExtensionInject(project);
        } else {
            PluginLog.INSTANCE.error(TAG, "Does not support Android Gradle Plugin " + VersionUtil.INSTANCE.getCurrentAGPVersion() + "!.", new Object[0]);
        }
        PluginLog.INSTANCE.info(TAG, "network task scheduled", new Object[0]);
    }

    private final boolean enableTrafficTransform() {
        return APMPluginConfiguration.Companion.getInstance().getPluginEnable() && APMPluginConfiguration.Companion.getInstance().getNetworkEnable();
    }

    private final void appExtensionInject(AppExtension appExtension, Project project) {
        APMTrafficTransform transform2 = new APMTrafficTransform(project);
        appExtension.registerTransform((Transform)transform2, new Object[0]);
        appExtension.getApplicationVariants().all(arg_0 -> TrafficService.appExtensionInject$lambda-0(transform2, arg_0));
    }

    private final void componentExtensionInject(Project project) {
        AndroidComponentsExtension androidComponents = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)androidComponents, (String)"androidComponents");
        AndroidComponentsExtension.onVariants$default((AndroidComponentsExtension)androidComponents, null, (Function1)((Function1)new Function1<Variant, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull Variant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                APMTrafficTransformClassVisitorFactoryHelper.INSTANCE.registerArtifactTransform(this.$project, variant);
            }
        }), (int)1, null);
    }

    private static final void appExtensionInject$lambda-0(APMTrafficTransform $transform, ApplicationVariant variant) {
        Intrinsics.checkNotNullParameter((Object)((Object)$transform), (String)"$transform");
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        $transform.setVariant(string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/cloud/apm/plugin/tasks/traffic/TrafficService$Companion;", "", "()V", "TAG", "", "serviceType", "transformList", "", "Lcom/cloud/apm/plugin/transform/transformer/Transformer;", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Transformer> transformList() {
            Object[] objectArray = new AbsTransformer[]{new Okhttp2ClassTransformer(), new Okhttp3ClassTransformer(), new UrlConnectionTransformer(), new WebViewTransformer()};
            return CollectionsKt.listOf((Object)new CommonTransformer(CollectionsKt.listOf((Object[])objectArray), null, 2, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

