/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.transform;

import com.cloud.apm.plugin.transform.CommonTransformClassNode;
import com.cloud.apm.plugin.transform.ITransformContext;
import com.cloud.apm.plugin.transform.Priority;
import com.cloud.apm.plugin.transform.transformer.ClassTransformer;
import com.cloud.apm.plugin.transform.transformer.Transformer;
import com.cloud.apm.plugin.utils.PluginLog;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0018\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J-\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\u00112\u0006\u0010\u001f\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!H\u0002\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/cloud/apm/plugin/transform/CommonTransformer;", "Lcom/cloud/apm/plugin/transform/transformer/Transformer;", "()V", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "mTransformers", "", "Lcom/cloud/apm/plugin/transform/transformer/ClassTransformer;", "mClassLoader", "(Ljava/lang/Iterable;Ljava/lang/ClassLoader;)V", "TAG", "", "durations", "", "", "threadMxBean", "Ljava/lang/management/ThreadMXBean;", "kotlin.jvm.PlatformType", "onPostDoTransform", "", "context", "Lcom/cloud/apm/plugin/transform/ITransformContext;", "onPreDoTransform", "transform", "", "bytecode", "Lorg/objectweb/asm/ClassVisitor;", "classVisitor", "sumCpuTime", "R", "transformer", "action", "Lkotlin/Function0;", "(Ljava/lang/management/ThreadMXBean;Lcom/cloud/apm/plugin/transform/transformer/ClassTransformer;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "apm-plugin"})
public final class CommonTransformer
implements Transformer {
    @NotNull
    private final Iterable<ClassTransformer> mTransformers;
    @NotNull
    private final ClassLoader mClassLoader;
    private final ThreadMXBean threadMxBean;
    @NotNull
    private final Map<ClassTransformer, Long> durations;
    @NotNull
    private final String TAG;

    public CommonTransformer(@NotNull Iterable<? extends ClassTransformer> mTransformers, @NotNull ClassLoader mClassLoader) {
        Intrinsics.checkNotNullParameter(mTransformers, (String)"mTransformers");
        Intrinsics.checkNotNullParameter((Object)mClassLoader, (String)"mClassLoader");
        this.mTransformers = mTransformers;
        this.mClassLoader = mClassLoader;
        this.threadMxBean = ManagementFactory.getThreadMXBean();
        this.durations = new LinkedHashMap();
        this.TAG = "CommonTransformer";
    }

    public /* synthetic */ CommonTransformer(Iterable iterable, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"currentThread().contextClassLoader");
            classLoader = classLoader2;
        }
        this(iterable, classLoader);
    }

    public CommonTransformer() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"currentThread().contextClassLoader");
        this(classLoader);
    }

    public CommonTransformer(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        ServiceLoader<ClassTransformer> serviceLoader = ServiceLoader.load(ClassTransformer.class, classLoader);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(ClassTransformer::class.java, classLoader)");
        Iterable $this$sortedBy$iv = serviceLoader;
        boolean $i$f$sortedBy = false;
        this(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ClassTransformer it = (ClassTransformer)a;
                boolean bl = false;
                Priority priority = it.getClass().getAnnotation(Priority.class);
                it = (ClassTransformer)b;
                Comparable comparable = Integer.valueOf(priority != null ? priority.value() : 0);
                bl = false;
                Priority priority2 = it.getClass().getAnnotation(Priority.class);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(priority2 != null ? priority2.value() : 0));
            }
        }), classLoader);
    }

    public /* synthetic */ CommonTransformer(ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"currentThread().contextClassLoader");
            classLoader = classLoader2;
        }
        this(classLoader);
    }

    @Override
    public void onPreDoTransform(@NotNull ITransformContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable<ClassTransformer> $this$forEach$iv = this.mTransformers;
        boolean $i$f$forEach = false;
        Iterator<ClassTransformer> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            ClassTransformer element$iv;
            ClassTransformer transformer2 = element$iv = iterator.next();
            boolean bl = false;
            ThreadMXBean threadMXBean = this.threadMxBean;
            Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"this.threadMxBean");
            this.sumCpuTime(threadMXBean, transformer2, (Function0)new Function0<Unit>(transformer2, context2){
                final /* synthetic */ ClassTransformer $transformer;
                final /* synthetic */ ITransformContext $context;
                {
                    this.$transformer = $transformer;
                    this.$context = $context;
                    super(0);
                }

                public final void invoke() {
                    this.$transformer.onPreDoTransform(this.$context);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] transform(@NotNull ITransformContext context2, @NotNull byte[] bytecode) {
        void $this$fold$iv;
        void initial$iv;
        ClassNode classNode;
        ClassWriter classWriter;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bytecode, (String)"bytecode");
        ClassWriter writer = classWriter = new ClassWriter(1);
        boolean bl = false;
        Iterable<ClassTransformer> iterable = this.mTransformers;
        ClassNode classNode2 = classNode = new ClassNode();
        boolean bl2 = false;
        new ClassReader(bytecode).accept((ClassVisitor)classNode2, 0);
        boolean $i$f$fold = false;
        ClassNode accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void transformer2;
            ClassTransformer classTransformer = (ClassTransformer)element$iv;
            void classNode3 = accumulator$iv;
            boolean bl3 = false;
            ThreadMXBean threadMXBean = this.threadMxBean;
            Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"this.threadMxBean");
            accumulator$iv = (ClassNode)this.sumCpuTime(threadMXBean, (ClassTransformer)transformer2, (Function0)new Function0<ClassNode>((ClassTransformer)transformer2, context2, (ClassNode)classNode3){
                final /* synthetic */ ClassTransformer $transformer;
                final /* synthetic */ ITransformContext $context;
                final /* synthetic */ ClassNode $classNode;
                {
                    this.$transformer = $transformer;
                    this.$context = $context;
                    this.$classNode = $classNode;
                    super(0);
                }

                @NotNull
                public final ClassNode invoke() {
                    return this.$transformer.transform(this.$context, this.$classNode);
                }
            });
        }
        accumulator$iv.accept((ClassVisitor)writer);
        byte[] byArray = classWriter.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ClassWriter(ClassWriter.\u2026)\n        }.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ClassVisitor transform(@NotNull ITransformContext context2, @NotNull ClassVisitor classVisitor) {
        void $this$fold$iv;
        void initial$iv;
        CommonTransformClassNode commonTransformClassNode;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)classVisitor, (String)"classVisitor");
        Iterable<ClassTransformer> iterable = this.mTransformers;
        CommonTransformClassNode klass = commonTransformClassNode = new CommonTransformClassNode(589824, classVisitor, null, 4, null);
        boolean bl = false;
        klass.name = context2.getName();
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void transformer2;
            ClassTransformer classTransformer = (ClassTransformer)element$iv;
            void klass2 = accumulator$iv;
            boolean bl2 = false;
            klass2.addEndBlock((Function0<Unit>)((Function0)new Function0<Unit>(this, (ClassTransformer)transformer2, context2, (CommonTransformClassNode)klass2){
                final /* synthetic */ CommonTransformer this$0;
                final /* synthetic */ ClassTransformer $transformer;
                final /* synthetic */ ITransformContext $context;
                final /* synthetic */ CommonTransformClassNode $klass;
                {
                    this.this$0 = $receiver;
                    this.$transformer = $transformer;
                    this.$context = $context;
                    this.$klass = $klass;
                    super(0);
                }

                public final void invoke() {
                    ThreadMXBean threadMXBean = CommonTransformer.access$getThreadMxBean$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"this.threadMxBean");
                    CommonTransformer.access$sumCpuTime(this.this$0, threadMXBean, this.$transformer, (Function0)new Function0<Unit>(this.$transformer, this.$context, this.$klass){
                        final /* synthetic */ ClassTransformer $transformer;
                        final /* synthetic */ ITransformContext $context;
                        final /* synthetic */ CommonTransformClassNode $klass;
                        {
                            this.$transformer = $transformer;
                            this.$context = $context;
                            this.$klass = $klass;
                            super(0);
                        }

                        public final void invoke() {
                            this.$transformer.transform(this.$context, this.$klass);
                        }
                    });
                }
            }));
            accumulator$iv = klass2;
        }
        return (ClassVisitor)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onPostDoTransform(@NotNull ITransformContext context2) {
        void $this$reduce$iv;
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable<ClassTransformer> $this$forEach$iv = this.mTransformers;
        boolean $i$f$forEach = false;
        Iterator<ClassTransformer> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            ClassTransformer classTransformer;
            ClassTransformer transformer2 = classTransformer = iterator.next();
            bl = false;
            ThreadMXBean threadMXBean = this.threadMxBean;
            Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"this.threadMxBean");
            this.sumCpuTime(threadMXBean, transformer2, (Function0)new Function0<Unit>(transformer2, context2){
                final /* synthetic */ ClassTransformer $transformer;
                final /* synthetic */ ITransformContext $context;
                {
                    this.$transformer = $transformer;
                    this.$context = $context;
                    super(0);
                }

                public final void invoke() {
                    this.$transformer.onPostDoTransform(this.$context);
                }
            });
        }
        Iterator iterator2 = ((Iterable)this.durations.keySet()).iterator();
        if (!iterator2.hasNext()) {
            object = null;
        } else {
            Object it = (ClassTransformer)iterator2.next();
            bl = false;
            it = it.getName().length();
            while (iterator2.hasNext()) {
                Object it2 = (ClassTransformer)iterator2.next();
                boolean bl2 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(it2.getName().length())) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Integer n = (Integer)object;
        int longest = n != null ? n : 20;
        Object $this$forEach$iv2 = this.durations;
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<ClassTransformer, Long>> iterator3 = $this$forEach$iv2.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry<ClassTransformer, Long> element$iv3;
            Map.Entry<ClassTransformer, Long> it2 = element$iv3 = iterator3.next();
            boolean bl3 = false;
            ClassTransformer transformer3 = it2.getKey();
            long ns = ((Number)it2.getValue()).longValue();
            PluginLog.INSTANCE.debug(this.TAG, StringsKt.padEnd$default((String)transformer3.getName(), (int)(longest + 1), (char)'\u0000', (int)2, null) + ": " + ns / (long)1000000 + " ms", new Object[0]);
        }
        $this$forEach$iv2 = this.durations.values();
        String string = StringsKt.padEnd$default((String)"total cost", (int)(longest + 1), (char)'\u0000', (int)2, null);
        String string2 = this.TAG;
        PluginLog pluginLog = PluginLog.INSTANCE;
        boolean $i$f$reduce = false;
        Iterator iterator4 = $this$reduce$iv.iterator();
        if (!iterator4.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator4.next();
        while (iterator4.hasNext()) {
            void duration;
            long it2 = ((Number)iterator4.next()).longValue();
            long acc = ((Number)accumulator$iv).longValue();
            boolean bl4 = false;
            accumulator$iv = acc + duration;
        }
        Object t = accumulator$iv;
        pluginLog.debug(string2, string + ": " + ((Number)t).longValue() / (long)1000000 + " ms", new Object[0]);
    }

    private final <R> R sumCpuTime(ThreadMXBean $this$sumCpuTime, ClassTransformer transformer2, Function0<? extends R> action2) {
        long cpuTime0 = $this$sumCpuTime.getCurrentThreadCpuTime();
        Object result = action2.invoke();
        long cpuTime1 = $this$sumCpuTime.getCurrentThreadCpuTime();
        this.durations.put(transformer2, ((Number)this.durations.getOrDefault(transformer2, 0L)).longValue() + (cpuTime1 - cpuTime0));
        return (R)result;
    }

    public static final /* synthetic */ Object access$sumCpuTime(CommonTransformer $this, ThreadMXBean $receiver, ClassTransformer transformer2, Function0 action2) {
        return $this.sumCpuTime($receiver, transformer2, action2);
    }

    public static final /* synthetic */ ThreadMXBean access$getThreadMxBean$p(CommonTransformer $this) {
        return $this.threadMxBean;
    }
}

