/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.utils;

import com.cloud.apm.plugin.utils.PluginLog;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0014J\u0010\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!2\u0006\u0010\"\u001a\u00020\u0014J\u0010\u0010#\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0010\u0010%\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0014J\u000e\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0006J\u0010\u0010'\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u0014J@\u0010'\u001a\u0004\u0018\u0001H(\"\u0004\b\u0000\u0010(2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00142!\u0010)\u001a\u001d\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b,\u0012\b\b-\u0012\u0004\b\b(.\u0012\u0004\u0012\u0002H(0*\u00a2\u0006\u0002\u0010/J\u000e\u0010'\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u000eJ@\u0010'\u001a\u0004\u0018\u0001H(\"\u0004\b\u0000\u0010(2\u0006\u00100\u001a\u00020\u000e2!\u0010)\u001a\u001d\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b,\u0012\b\b-\u0012\u0004\b\b(.\u0012\u0004\u0012\u0002H(0*H\u0002\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0014J\u000e\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006J \u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0006H\u0002J\u0010\u00107\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/cloud/apm/plugin/utils/FileUtil;", "", "()V", "BUFFER_SIZE", "", "TAG", "", "addZipEntry", "", "zipOutputStream", "Ljava/util/zip/ZipOutputStream;", "zipEntry", "Ljava/util/zip/ZipEntry;", "inputStream", "Ljava/io/InputStream;", "closeQuietly", "closeable", "Ljava/io/Closeable;", "copyFile", "from", "Ljava/io/File;", "to", "copyFileUsingStream", "source", "dest", "deleteDir", "", "file", "deleteIfExists", "flushQuietly", "flushable", "Ljava/io/Flushable;", "getAllFiles", "", "dir", "isClassFile", "string", "isLegalFile", "fileName", "readFile", "Type", "bufferedReaderBlock", "Lkotlin/Function1;", "Ljava/io/BufferedReader;", "Lkotlin/ParameterName;", "name", "reader", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "fileInputStream", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readFileAsString", "filePath", "readFileError", "tag", "desc", "safeDeleteFile", "apm-plugin"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();
    private static final int BUFFER_SIZE = 16384;
    @NotNull
    private static final String TAG = "FileUtil";

    private FileUtil() {
    }

    private final void readFileError(String tag, String file, String desc) {
        PluginLog.INSTANCE.warning(tag, "read file " + file + " fail: " + desc, new Object[0]);
    }

    public final boolean isLegalFile(@Nullable File file) {
        return file != null && file.exists() && file.canRead() && file.isFile() && file.length() > 0L;
    }

    public final boolean isLegalFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = new File(fileName);
        return this.isLegalFile(file);
    }

    public final void copyFile(@NotNull File from, @NotNull File to) throws IOException {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
        Files.copy(from.toPath(), to.toPath(), copyOptionArray);
    }

    public final void deleteIfExists(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Files.deleteIfExists(file.toPath());
    }

    public final boolean safeDeleteFile(@Nullable File file) {
        if (file == null) {
            return true;
        }
        if (file.exists()) {
            boolean deleted = file.delete();
            if (!deleted) {
                Object[] objectArray = new Object[]{file.getPath()};
                PluginLog.INSTANCE.warning(TAG, "Failed to delete file: %s, try to delete when exit.", objectArray);
                file.deleteOnExit();
            }
            return deleted;
        }
        return true;
    }

    public final boolean deleteDir(@Nullable File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isFile()) {
            this.safeDeleteFile(file);
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return true;
            }
            for (File subFile : fileArray) {
                this.deleteDir(subFile);
            }
            this.safeDeleteFile(file);
        }
        return true;
    }

    @NotNull
    public final List<File> getAllFiles(@NotNull File dir) {
        File[] files;
        File[] fileArray;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ArrayList<File> list = new ArrayList<File>();
        if (dir.isDirectory() && !((fileArray = (files = dir.listFiles())) == null || fileArray.length == 0)) {
            Intrinsics.checkNotNullExpressionValue((Object)files, (String)"files");
            for (File fileIndex : files) {
                if (fileIndex.isDirectory()) {
                    Intrinsics.checkNotNullExpressionValue((Object)fileIndex, (String)"fileIndex");
                    list.addAll((Collection)this.getAllFiles(fileIndex));
                    continue;
                }
                list.add(fileIndex);
            }
        }
        return list;
    }

    public final void closeQuietly(@Nullable Closeable closeable) {
        try {
            Closeable closeable2 = closeable;
            if (closeable2 != null) {
                closeable2.close();
            }
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            PluginLog.INSTANCE.warning(TAG, "Failed to close resource %s", objectArray);
        }
    }

    public final void flushQuietly(@Nullable Flushable flushable) {
        try {
            Flushable flushable2 = flushable;
            if (flushable2 != null) {
                flushable2.flush();
            }
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            PluginLog.INSTANCE.warning(TAG, "Failed to flush resource: %s", objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyFileUsingStream(@NotNull File source, @NotNull File dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            inputStream = new FileInputStream(source);
            outputStream = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            int length = 0;
            while (true) {
                int n;
                int it = n = inputStream.read(buffer);
                boolean bl = false;
                length = it;
                if (n > 0) {
                    outputStream.write(buffer, 0, length);
                    continue;
                }
                break;
            }
        }
        finally {
            this.closeQuietly(inputStream);
            this.closeQuietly(outputStream);
        }
    }

    @NotNull
    public final String readFileAsString(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        return this.readFileAsString(file);
    }

    @NotNull
    public final String readFileAsString(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            PluginLog.INSTANCE.debug(TAG, "file " + file.getPath() + " is not exists", new Object[0]);
            return "";
        }
        return this.readFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readFile(@Nullable File file) {
        FileInputStream fileInputStream = null;
        String result = "";
        try {
            fileInputStream = new FileInputStream(file);
            result = this.readFile(fileInputStream);
        }
        catch (Exception e) {
            String string = String.valueOf(fileInputStream);
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            this.readFileError(TAG, string, string2);
        }
        finally {
            this.closeQuietly(fileInputStream);
        }
        return result;
    }

    @NotNull
    public final String readFile(@NotNull InputStream fileInputStream) {
        Intrinsics.checkNotNullParameter((Object)fileInputStream, (String)"fileInputStream");
        StringBuilder resultStrBuilder = new StringBuilder();
        String string = (String)this.readFile(fileInputStream, (Function1)new Function1<BufferedReader, String>(resultStrBuilder){
            final /* synthetic */ StringBuilder $resultStrBuilder;
            {
                this.$resultStrBuilder = $resultStrBuilder;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull BufferedReader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                String line = null;
                while (true) {
                    String string;
                    String it = string = reader.readLine();
                    boolean bl = false;
                    line = it;
                    if (string == null) break;
                    this.$resultStrBuilder.append(line).append("\n");
                }
                return this.$resultStrBuilder.toString();
            }
        });
        return string == null ? "" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <Type> Type readFile(@Nullable File file, @NotNull Function1<? super BufferedReader, ? extends Type> bufferedReaderBlock) {
        Intrinsics.checkNotNullParameter(bufferedReaderBlock, (String)"bufferedReaderBlock");
        FileInputStream fileInputStream = null;
        Type result = null;
        try {
            fileInputStream = new FileInputStream(file);
            result = this.readFile(fileInputStream, bufferedReaderBlock);
        }
        catch (Exception e) {
            String string = String.valueOf(fileInputStream);
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            this.readFileError(TAG, string, string2);
        }
        finally {
            this.closeQuietly(fileInputStream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <Type> Type readFile(InputStream fileInputStream, Function1<? super BufferedReader, ? extends Type> bufferedReaderBlock) {
        Object result = null;
        InputStreamReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            reader = new InputStreamReader(fileInputStream, "UTF-8");
            bufferedReader = new BufferedReader(reader);
            result = bufferedReaderBlock.invoke((Object)bufferedReader);
        }
        catch (Throwable t) {
            String string = fileInputStream.toString();
            String string2 = t.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            this.readFileError(TAG, string, string2);
        }
        finally {
            this.closeQuietly(bufferedReader);
            this.closeQuietly(reader);
        }
        return (Type)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addZipEntry(@NotNull ZipOutputStream zipOutputStream, @NotNull ZipEntry zipEntry, @NotNull InputStream inputStream) throws Exception {
        Intrinsics.checkNotNullParameter((Object)zipOutputStream, (String)"zipOutputStream");
        Intrinsics.checkNotNullParameter((Object)zipEntry, (String)"zipEntry");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try {
            zipOutputStream.putNextEntry(zipEntry);
            byte[] buffer = new byte[16384];
            int length = 0;
            while (true) {
                int n;
                int it = n = inputStream.read(buffer, 0, buffer.length);
                boolean bl = false;
                length = it;
                if (n != -1) {
                    zipOutputStream.write(buffer, 0, length);
                    zipOutputStream.flush();
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            PluginLog.INSTANCE.warning(TAG, "addZipEntry " + zipEntry.getName() + " to " + zipOutputStream + " failed : " + e, new Object[0]);
        }
        finally {
            this.closeQuietly(inputStream);
            zipOutputStream.closeEntry();
        }
    }

    public final boolean isClassFile(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String regex = "^[\\S|\\s]*.class$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }
}

