/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.utils;

import com.cloud.apm.plugin.utils.PluginLog;
import java.io.Closeable;
import java.io.File;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001H\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/cloud/apm/plugin/utils/IOUtil;", "", "()V", "closeQuietly", "", "obj", "isZipOrJar", "", "input", "Ljava/io/File;", "apm-plugin"})
public final class IOUtil {
    @NotNull
    public static final IOUtil INSTANCE = new IOUtil();

    private IOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isZipOrJar(@NotNull File input) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ZipFile zf = null;
        try {
            zf = new ZipFile(input);
            bl = true;
            this.closeQuietly(zf);
        }
        catch (Exception e) {
            try {
                bl = false;
                this.closeQuietly(zf);
            }
            catch (Throwable throwable) {
                this.closeQuietly(zf);
                throw throwable;
            }
        }
        return bl;
    }

    private final void closeQuietly(Object obj) {
        try {
            Object object = obj;
            if (object instanceof Closeable) {
                ((Closeable)obj).close();
            } else if (object instanceof AutoCloseable) {
                ((AutoCloseable)obj).close();
            } else if (object != null) {
                throw new IllegalArgumentException("obj " + obj + " is not closeable");
            }
        }
        catch (Throwable ignored) {
            String string = ignored.getMessage();
            if (string == null) {
                string = "";
            }
            PluginLog.INSTANCE.warning("", string, new Object[0]);
        }
    }
}

