/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.construct;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.cloud.apm.plugin.tasks.construct.ApmSdkConfig;
import com.cloud.apm.plugin.tasks.construct.ApmSdkPluginConfig;
import com.cloud.apm.plugin.tasks.construct.ApmSdkPluginNetworkConfig;
import com.cloud.apm.plugin.tasks.construct.ApmSdkPluginTraceConfig;
import com.cloud.apm.plugin.utils.APMPluginConfiguration;
import com.cloud.apm.plugin.utils.APMPluginErrorException;
import com.cloud.apm.plugin.utils.FileUtil;
import com.cloud.apm.plugin.utils.PluginLog;
import com.cloud.apm.plugin.utils.TraceExtension;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u001a\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/cloud/apm/plugin/tasks/construct/ConstructService;", "", "()V", "checkConfigFileExist", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "inject", "", "appExtension", "Lcom/android/build/gradle/AppExtension;", "injectJsonAction", "configName", "", "jsonConfigFile", "mergeJSONAssets", "updatePluginConfiguration", "apmSdkPluginConfig", "Lcom/cloud/apm/plugin/tasks/construct/ApmSdkPluginConfig;", "Companion", "apm-plugin"})
public final class ConstructService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TAG = "ConstructService";

    public final void inject(@NotNull AppExtension appExtension, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)appExtension, (String)"appExtension");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File jsonConfigFile = this.checkConfigFileExist(project);
        String jsonString = FileUtil.INSTANCE.readFileAsString(jsonConfigFile);
        JsonElement root = JsonParser.parseString((String)jsonString);
        if (!root.isJsonObject()) {
            String string = "Json file %s parser fail. please check content at: %s";
            Object[] objectArray = new Object[]{jsonConfigFile.getName(), jsonConfigFile.getAbsolutePath()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new APMPluginErrorException(string2);
        }
        Object[] objectArray = new Object[]{jsonConfigFile.getName(), root.getAsJsonObject()};
        PluginLog.INSTANCE.debug(TAG, "Json file %s 's data: %s", objectArray);
        try {
            ApmSdkConfig sdkConfig;
            Gson gson = new GsonBuilder().serializeNulls().create();
            ApmSdkConfig apmSdkConfig = sdkConfig = (ApmSdkConfig)gson.fromJson(jsonString, ApmSdkConfig.class);
            String loggerLevel = apmSdkConfig != null ? apmSdkConfig.getLoggerLevel() : null;
            PluginLog.INSTANCE.setLogLevel(loggerLevel);
            this.updatePluginConfiguration(sdkConfig.getConfig(), project);
        }
        catch (Exception e) {
            String string = "process apm config failed: %s";
            Object[] objectArray2 = new Object[]{jsonString};
            String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            throw new APMPluginErrorException(string3, e);
        }
        project.afterEvaluate(arg_0 -> ConstructService.inject$lambda-0(this, appExtension, project, jsonConfigFile, arg_0));
        PluginLog.INSTANCE.info(TAG, "construct task scheduled", new Object[0]);
    }

    private final void mergeJSONAssets(AppExtension appExtension, Project project, File jsonConfigFile) {
        appExtension.getApplicationVariants().all(arg_0 -> ConstructService.mergeJSONAssets$lambda-2(this, project, jsonConfigFile, arg_0));
    }

    private final void injectJsonAction(Project project, String configName, File jsonConfigFile) {
        if (!jsonConfigFile.exists()) {
            return;
        }
        String string = configName.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        String destPath1 = "intermediates/merged_assets/" + string + "/out/apm-sdk-config.json";
        String destPath2 = "intermediates/assets/" + configName + "/apm-sdk-config.json";
        String destPath3 = "intermediates/assets/" + configName + "/merge" + configName + "Assets/apm-sdk-config.json";
        Object[] objectArray = new String[]{destPath1, destPath2, destPath3};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            File destFile = new File(project.getBuildDir(), it);
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            FileUtil.INSTANCE.copyFile(jsonConfigFile, destFile);
        }
    }

    private final void updatePluginConfiguration(ApmSdkPluginConfig apmSdkPluginConfig, Project project) {
        Object object;
        List<String> list;
        List<String> list2;
        Object object2;
        List<String> list3;
        List<String> list4;
        Object object3;
        Object object4;
        boolean it;
        ApmSdkPluginConfig it2 = apmSdkPluginConfig;
        boolean bl = false;
        APMPluginConfiguration.Companion.getInstance().setPluginEnable(true);
        Object object5 = apmSdkPluginConfig;
        if (object5 != null && (object5 = ((ApmSdkPluginConfig)object5).getNetwork()) != null) {
            it = ((ApmSdkPluginNetworkConfig)object5).getOkHttpEnable();
            boolean bl2 = false;
            APMPluginConfiguration.Companion.getInstance().getNetwork().setOkHttp(it);
        }
        if ((object4 = apmSdkPluginConfig) != null && (object4 = ((ApmSdkPluginConfig)object4).getNetwork()) != null) {
            it = ((ApmSdkPluginNetworkConfig)object4).getUrlConnectionEnable();
            boolean bl3 = false;
            APMPluginConfiguration.Companion.getInstance().getNetwork().setUrlConnect(it);
        }
        if ((object3 = apmSdkPluginConfig) != null && (object3 = ((ApmSdkPluginConfig)object3).getNetwork()) != null) {
            it = ((ApmSdkPluginNetworkConfig)object3).getWebViewEnable();
            boolean bl4 = false;
            APMPluginConfiguration.Companion.getInstance().getNetwork().setWebView(it);
        }
        if ((list4 = apmSdkPluginConfig) != null && (list4 = ((ApmSdkPluginConfig)((Object)list4)).getNetwork()) != null && (list4 = ((ApmSdkPluginNetworkConfig)((Object)list4)).getWhitelist()) != null) {
            List<String> it3 = list4;
            boolean bl5 = false;
            APMPluginConfiguration.Companion.getInstance().getNetwork().setWhiteList(it3);
        }
        if ((list3 = apmSdkPluginConfig) != null && (list3 = ((ApmSdkPluginConfig)((Object)list3)).getNetwork()) != null && (list3 = ((ApmSdkPluginNetworkConfig)((Object)list3)).getBlackList()) != null) {
            List<String> it4 = list3;
            boolean bl6 = false;
            APMPluginConfiguration.Companion.getInstance().getNetwork().setBlackList(it4);
        }
        if ((object2 = apmSdkPluginConfig) != null && (object2 = ((ApmSdkPluginConfig)object2).getTrace()) != null) {
            boolean it5 = ((ApmSdkPluginTraceConfig)object2).getMethodTraceEnable();
            boolean bl7 = false;
            APMPluginConfiguration.Companion.getInstance().getTrace().setMethodTraceEnable(it5);
        }
        if ((list2 = apmSdkPluginConfig) != null && (list2 = ((ApmSdkPluginConfig)((Object)list2)).getTrace()) != null && (list2 = ((ApmSdkPluginTraceConfig)((Object)list2)).getWhitelist()) != null) {
            List<String> it6 = list2;
            boolean bl8 = false;
            APMPluginConfiguration.Companion.getInstance().getTrace().setWhiteList(it6);
        }
        if ((list = apmSdkPluginConfig) != null && (list = ((ApmSdkPluginConfig)((Object)list)).getTrace()) != null && (list = ((ApmSdkPluginTraceConfig)((Object)list)).getBlackList()) != null) {
            List<String> it7 = list;
            boolean bl9 = false;
            APMPluginConfiguration.Companion.getInstance().getTrace().setBlackList(it7);
        }
        if ((object = apmSdkPluginConfig) != null && (object = ((ApmSdkPluginConfig)object).getTrace()) != null && (object = ((ApmSdkPluginTraceConfig)object).getBlockListFilePath()) != null) {
            Object it8 = object;
            boolean bl10 = false;
            TraceExtension traceExtension = APMPluginConfiguration.Companion.getInstance().getTrace();
            String string = new File(project.getProjectDir(), (String)it8).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(project.projectDir,  it).absolutePath");
            traceExtension.setBlockListFilePath(string);
        }
        PluginLog.INSTANCE.debug(TAG, "plugin config is:\n" + APMPluginConfiguration.Companion.getInstance(), new Object[0]);
    }

    private final File checkConfigFileExist(Project project) {
        File jsonFile = project.file((Object)"apm-sdk-config.json");
        if (!jsonFile.isFile()) {
            String lineSeparator = System.lineSeparator();
            String searchedLocation = lineSeparator + jsonFile.getPath();
            String string = "File %s is missing. APM can't function without it. Searched location at: %s";
            Object[] objectArray = new Object[]{jsonFile.getName(), searchedLocation};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new APMPluginErrorException(string2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)jsonFile, (String)"jsonFile");
        return jsonFile;
    }

    private static final void inject$lambda-0(ConstructService this$0, AppExtension $appExtension, Project $project, File $jsonConfigFile, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$appExtension, (String)"$appExtension");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$jsonConfigFile, (String)"$jsonConfigFile");
        this$0.mergeJSONAssets($appExtension, $project, $jsonConfigFile);
    }

    private static final void mergeJSONAssets$lambda-2$lambda-1(ConstructService this$0, Project $project, String $configName, File $jsonConfigFile, Task it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$configName, (String)"$configName");
        Intrinsics.checkNotNullParameter((Object)$jsonConfigFile, (String)"$jsonConfigFile");
        this$0.injectJsonAction($project, $configName, $jsonConfigFile);
    }

    private static final void mergeJSONAssets$lambda-2(ConstructService this$0, Project $project, File $jsonConfigFile, ApplicationVariant it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$jsonConfigFile, (String)"$jsonConfigFile");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
        String configName = StringsKt.capitalize((String)string);
        ((MergeSourceSetFolders)it.getMergeAssetsProvider().get()).doLast(arg_0 -> ConstructService.mergeJSONAssets$lambda-2$lambda-1(this$0, $project, configName, $jsonConfigFile, arg_0));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cloud/apm/plugin/tasks/construct/ConstructService$Companion;", "", "()V", "TAG", "", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

