/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace;

import com.android.build.api.transform.Status;
import com.cloud.apm.plugin.tasks.trace.Trace;
import com.cloud.apm.plugin.tasks.trace.TraceConfiguration;
import com.cloud.apm.plugin.tasks.trace.TraceUtils;
import com.cloud.apm.plugin.tasks.trace.mapping.MappingCollector;
import com.cloud.apm.plugin.tasks.trace.mapping.MappingReader;
import com.cloud.apm.plugin.tasks.trace.methodTrace.AgpCompat;
import com.cloud.apm.plugin.tasks.trace.methodTrace.MethodCollector;
import com.cloud.apm.plugin.tasks.trace.methodTrace.MethodTracer;
import com.cloud.apm.plugin.tasks.trace.methodTrace.TraceClassLoader;
import com.cloud.apm.plugin.tasks.trace.methodTrace.TraceMethod;
import com.cloud.apm.plugin.utils.FileUtil;
import com.cloud.apm.plugin.utils.IOUtil;
import com.cloud.apm.plugin.utils.PluginLog;
import com.cloud.apm.plugin.utils.TransformUtilKt;
import java.io.Closeable;
import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0004\u001f !\"B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u00a2\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0018\u001a\u00020\u00132D\b\u0002\u0010\u0019\u001a>\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0015\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\f0\u001aR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/Trace;", "", "project", "Lorg/gradle/api/Project;", "mappingDir", "", "methodMapFilePath", "baseMethodMapPath", "blockListFilePath", "ignoreMethodMapFilePath", "(Lorg/gradle/api/Project;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "doTransform", "", "isIncremental", "", "skipCheckClass", "uniqueOutputName", "classInputs", "", "Ljava/io/File;", "changedFiles", "", "Lcom/android/build/api/transform/Status;", "inputToOutput", "traceClassDirectoryOutput", "postProcessBlock", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "Ljava/util/concurrent/ExecutorService;", "executor", "CollectDirectoryInputTask", "CollectJarInputTask", "Companion", "ParseMappingTask", "apm-plugin"})
public final class Trace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String mappingDir;
    @NotNull
    private final String methodMapFilePath;
    @Nullable
    private final String baseMethodMapPath;
    @Nullable
    private final String blockListFilePath;
    @NotNull
    private final String ignoreMethodMapFilePath;
    @NotNull
    private static final String TAG = "Trace";

    public Trace(@NotNull Project project, @NotNull String mappingDir, @NotNull String methodMapFilePath, @Nullable String baseMethodMapPath, @Nullable String blockListFilePath, @NotNull String ignoreMethodMapFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mappingDir, (String)"mappingDir");
        Intrinsics.checkNotNullParameter((Object)methodMapFilePath, (String)"methodMapFilePath");
        Intrinsics.checkNotNullParameter((Object)ignoreMethodMapFilePath, (String)"ignoreMethodMapFilePath");
        this.project = project;
        this.mappingDir = mappingDir;
        this.methodMapFilePath = methodMapFilePath;
        this.baseMethodMapPath = baseMethodMapPath;
        this.blockListFilePath = blockListFilePath;
        this.ignoreMethodMapFilePath = ignoreMethodMapFilePath;
    }

    public final void doTransform(boolean isIncremental, boolean skipCheckClass, boolean uniqueOutputName, @NotNull Collection<? extends File> classInputs, @NotNull Map<File, ? extends Status> changedFiles, @NotNull Map<File, ? extends File> inputToOutput, @NotNull File traceClassDirectoryOutput, @NotNull Function2<? super Map<File, ? extends File>, ? super ExecutorService, Unit> postProcessBlock2) {
        Object it;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(classInputs, (String)"classInputs");
        Intrinsics.checkNotNullParameter(changedFiles, (String)"changedFiles");
        Intrinsics.checkNotNullParameter(inputToOutput, (String)"inputToOutput");
        Intrinsics.checkNotNullParameter((Object)traceClassDirectoryOutput, (String)"traceClassDirectoryOutput");
        Intrinsics.checkNotNullParameter(postProcessBlock2, (String)"postProcessBlock");
        ExecutorService executor2 = TransformUtilKt.executorServiceFactory();
        TraceConfiguration config = new TraceConfiguration.Builder().setIgnoreMethodMapFilePath(this.ignoreMethodMapFilePath).setMethodMapFilePath(this.methodMapFilePath).setBaseMethodMap(this.baseMethodMapPath).setBlockListFile(this.blockListFilePath).setSkipCheckClass(skipCheckClass).setMappingPath(this.mappingDir).build();
        AgpCompat.INSTANCE.getAsmApi(this.project);
        long timestamp = System.currentTimeMillis();
        LinkedList futureList = new LinkedList();
        MappingCollector mappingCollector = new MappingCollector();
        AtomicInteger methodId = new AtomicInteger(0);
        ConcurrentHashMap<String, TraceMethod> collectedMethodMap = new ConcurrentHashMap<String, TraceMethod>();
        futureList.add(executor2.submit(new ParseMappingTask(mappingCollector, collectedMethodMap, methodId, config)));
        ConcurrentHashMap<File, File> dirInputOutMap = new ConcurrentHashMap<File, File>();
        ConcurrentHashMap<File, File> jarInputOutMap = new ConcurrentHashMap<File, File>();
        Iterable $this$forEach$iv = classInputs;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            File file = (File)element$iv2;
            boolean bl = false;
            if (file.isDirectory()) {
                futureList.add(executor2.submit(new CollectDirectoryInputTask(isIncremental, file, traceClassDirectoryOutput, changedFiles, inputToOutput, (Map<File, File>)dirInputOutMap)));
                continue;
            }
            Status status = Status.CHANGED;
            futureList.add(executor2.submit(new CollectJarInputTask(file, status, isIncremental, uniqueOutputName, traceClassDirectoryOutput, inputToOutput, (Map<File, File>)jarInputOutMap)));
        }
        $this$forEach$iv = futureList;
        $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            it = (Future)element$iv2;
            boolean bl = false;
            it.get();
        }
        futureList.clear();
        PluginLog.INSTANCE.info(TAG, "[doTransform] Step(1)[Parse]... cost:" + (System.currentTimeMillis() - timestamp) + "ms", new Object[0]);
        timestamp = System.currentTimeMillis();
        MethodCollector methodCollector = new MethodCollector(executor2, mappingCollector, methodId, config, collectedMethodMap);
        Set set = dirInputOutMap.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"dirInputOutMap.keys");
        Set set2 = jarInputOutMap.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"jarInputOutMap.keys");
        methodCollector.collect(set, set2);
        PluginLog.INSTANCE.info(TAG, "[doTransform] Step(2)[Collection]... cost:" + (System.currentTimeMillis() - timestamp) + "ms", new Object[0]);
        timestamp = System.currentTimeMillis();
        MethodTracer tracer = new MethodTracer(executor2, mappingCollector, config, methodCollector.getCollectedMethodMap(), methodCollector.getCollectedClassExtendMap());
        element$iv2 = new ArrayList();
        it = element$iv2;
        boolean bl = false;
        ((ArrayList)it).addAll(dirInputOutMap.keySet());
        ((ArrayList)it).addAll(jarInputOutMap.keySet());
        Object inputs = element$iv2;
        URLClassLoader traceLoader = TraceClassLoader.INSTANCE.getClassLoader(this.project, (Collection)inputs);
        tracer.trace((Map<File, ? extends File>)dirInputOutMap, (Map<File, ? extends File>)jarInputOutMap, traceLoader, skipCheckClass);
        PluginLog.INSTANCE.info(TAG, "[doTransform] Step(3)[Trace]... cost:" + (System.currentTimeMillis() - timestamp) + "ms", new Object[0]);
        TraceUtils.INSTANCE.blockCostPrint(PluginLog.INSTANCE, TAG, "[doTransform] Step(4)[Post Trace]...", (Function0<Unit>)((Function0)new Function0<Unit>(postProcessBlock2, dirInputOutMap, jarInputOutMap, executor2){
            final /* synthetic */ Function2<Map<File, ? extends File>, ExecutorService, Unit> $postProcessBlock;
            final /* synthetic */ ConcurrentHashMap<File, File> $dirInputOutMap;
            final /* synthetic */ ConcurrentHashMap<File, File> $jarInputOutMap;
            final /* synthetic */ ExecutorService $executor;
            {
                this.$postProcessBlock = $postProcessBlock;
                this.$dirInputOutMap = $dirInputOutMap;
                this.$jarInputOutMap = $jarInputOutMap;
                this.$executor = $executor;
                super(0);
            }

            public final void invoke() {
                this.$postProcessBlock.invoke((Object)MapsKt.plus((Map)this.$dirInputOutMap, (Map)this.$jarInputOutMap), (Object)this.$executor);
            }
        }));
    }

    public static /* synthetic */ void doTransform$default(Trace trace, boolean bl, boolean bl2, boolean bl3, Collection collection, Map map, Map map2, File file, Function2 function2, int n, Object object) {
        if ((n & 0x80) != 0) {
            function2 = doTransform.1.INSTANCE;
        }
        trace.doTransform(bl, bl2, bl3, collection, map, map2, file, (Function2<? super Map<File, ? extends File>, ? super ExecutorService, Unit>)function2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/Trace$Companion;", "", "()V", "TAG", "", "appendSuffix", "jarFile", "Ljava/io/File;", "suffix", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String appendSuffix(@NotNull File jarFile, @Nullable String suffix) {
            String string;
            String realSuffix;
            Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
            String origJarName = jarFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)origJarName, (String)"origJarName");
            int dotPos = StringsKt.lastIndexOf$default((CharSequence)origJarName, (char)'.', (int)0, (boolean)false, (int)6, null);
            String string2 = suffix;
            if (string2 == null) {
                string2 = realSuffix = String.valueOf(jarFile.getPath().hashCode());
            }
            if (dotPos < 0) {
                String string3 = "%s_%s";
                Object[] objectArray = new Object[]{origJarName, realSuffix};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            } else {
                String string5 = origJarName.substring(0, dotPos);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String nameWithoutDotExt = string5;
                String string6 = origJarName.substring(dotPos);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                String dotExt = string6;
                String string7 = "%s_%s%s";
                Object[] objectArray = new Object[]{nameWithoutDotExt, realSuffix, dotExt};
                String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
                string = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(format, *args)");
            }
            return string;
        }

        public static /* synthetic */ String appendSuffix$default(Companion companion, File file, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.appendSuffix(file, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J$\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00032\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/Trace$ParseMappingTask;", "Ljava/lang/Runnable;", "mappingCollector", "Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector;", "collectedMethodMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/cloud/apm/plugin/tasks/trace/methodTrace/TraceMethod;", "methodId", "Ljava/util/concurrent/atomic/AtomicInteger;", "config", "Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;", "(Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector;Ljava/util/concurrent/ConcurrentHashMap;Ljava/util/concurrent/atomic/AtomicInteger;Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;)V", "getMethodFromBaseMethod", "", "baseMethodFile", "Ljava/io/File;", "retraceMethodMap", "processor", "methodMap", "run", "apm-plugin"})
    public static final class ParseMappingTask
    implements Runnable {
        @NotNull
        private final MappingCollector mappingCollector;
        @NotNull
        private final ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
        @NotNull
        private final AtomicInteger methodId;
        @NotNull
        private final TraceConfiguration config;

        public ParseMappingTask(@NotNull MappingCollector mappingCollector, @NotNull ConcurrentHashMap<String, TraceMethod> collectedMethodMap, @NotNull AtomicInteger methodId, @NotNull TraceConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)mappingCollector, (String)"mappingCollector");
            Intrinsics.checkNotNullParameter(collectedMethodMap, (String)"collectedMethodMap");
            Intrinsics.checkNotNullParameter((Object)methodId, (String)"methodId");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.mappingCollector = mappingCollector;
            this.collectedMethodMap = collectedMethodMap;
            this.methodId = methodId;
            this.config = config;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            File mappingFile = new File(this.config.getMappingDir(), "mapping.txt");
            if (mappingFile.isFile()) {
                new MappingReader(mappingFile).read(this.mappingCollector);
            }
            int size = this.config.parseBlockFile(this.mappingCollector);
            this.getMethodFromBaseMethod(new File(this.config.getBaseMethodMapPath()), this.collectedMethodMap);
            this.retraceMethodMap(this.mappingCollector, this.collectedMethodMap);
            long end = System.currentTimeMillis();
            PluginLog.INSTANCE.info(Trace.TAG, "[ParseMappingTask#run] cost:" + (end - start) + "ms, black size:" + size + ", collect " + this.collectedMethodMap.size() + " method from " + this.config.getBaseMethodMapPath(), new Object[0]);
        }

        private final void retraceMethodMap(MappingCollector processor, ConcurrentHashMap<String, TraceMethod> methodMap) {
            HashMap retraceMethodMap = new HashMap(methodMap.size());
            for (TraceMethod traceMethod : methodMap.values()) {
                traceMethod.proguard(processor);
                Map map = retraceMethodMap;
                String string = traceMethod.getRealMethodName();
                Intrinsics.checkNotNullExpressionValue((Object)traceMethod, (String)"traceMethod");
                map.put(string, traceMethod);
            }
            methodMap.clear();
            methodMap.putAll(retraceMethodMap);
            retraceMethodMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void getMethodFromBaseMethod(File baseMethodFile, ConcurrentHashMap<String, TraceMethod> collectedMethodMap) {
            Object object = new Object[]{baseMethodFile.getAbsolutePath()};
            PluginLog.INSTANCE.debug(Trace.TAG, "[getMethodFromBaseMethod] baseMethod file is %s", object);
            if (!baseMethodFile.exists()) {
                PluginLog.INSTANCE.warning(Trace.TAG, "[getMethodFromBaseMethod] baseMethod file not exist!", new Object[0]);
                return;
            }
            try {
                object = new Scanner(baseMethodFile, "UTF-8");
                Throwable throwable = null;
                try {
                    Scanner fileReader = (Scanner)object;
                    boolean bl = false;
                    while (fileReader.hasNext()) {
                        String currentLine = fileReader.nextLine();
                        Object[] objectArray = (Object[])currentLine;
                        if (objectArray == null || objectArray.length() == 0) continue;
                        String string = currentLine;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentLine");
                        String string2 = currentLine = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentLine");
                        if (StringsKt.startsWith$default((String)string2, (String)"#", (boolean)false, (int)2, null)) {
                            objectArray = new Object[]{currentLine};
                            PluginLog.INSTANCE.debug(Trace.TAG, "[getMethodFromBaseMethod] comment %s", objectArray);
                            continue;
                        }
                        String[] stringArray = new String[]{","};
                        List fields = StringsKt.split$default((CharSequence)currentLine, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        TraceMethod traceMethodInfo = new TraceMethod();
                        traceMethodInfo.setId(Integer.parseInt((String)fields.get(0)));
                        traceMethodInfo.setAccessFlag(Integer.parseInt((String)fields.get(1)));
                        String[] stringArray2 = new String[]{" "};
                        List methodField = StringsKt.split$default((CharSequence)((CharSequence)fields.get(2)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                        traceMethodInfo.setClassName(StringsKt.replace$default((String)((String)methodField.get(0)), (String)"/", (String)".", (boolean)false, (int)4, null));
                        traceMethodInfo.setMethodName((String)methodField.get(1));
                        if (methodField.size() > 2) {
                            traceMethodInfo.setDesc(StringsKt.replace$default((String)((String)methodField.get(2)), (String)"/", (String)".", (boolean)false, (int)4, null));
                        }
                        ((Map)collectedMethodMap).put(traceMethodInfo.getRealMethodName(), traceMethodInfo);
                        if (this.methodId.get() >= traceMethodInfo.getId() || traceMethodInfo.getId() == 1048574) continue;
                        this.methodId.set(traceMethodInfo.getId());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Throwable e) {
                PluginLog.INSTANCE.printErrStackTrace(Trace.TAG, e, "parse baseMethod file failed", new Object[0]);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/Trace$CollectDirectoryInputTask;", "Ljava/lang/Runnable;", "isIncremental", "", "directoryInput", "Ljava/io/File;", "traceClassDirectoryOutput", "mapOfChangedFiles", "", "Lcom/android/build/api/transform/Status;", "mapOfInputToOutput", "resultOfDirInputToOut", "", "(ZLjava/io/File;Ljava/io/File;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "run", "", "taskHandle", "apm-plugin"})
    public static final class CollectDirectoryInputTask
    implements Runnable {
        private final boolean isIncremental;
        @NotNull
        private final File directoryInput;
        @NotNull
        private final File traceClassDirectoryOutput;
        @NotNull
        private final Map<File, Status> mapOfChangedFiles;
        @NotNull
        private final Map<File, File> mapOfInputToOutput;
        @NotNull
        private final Map<File, File> resultOfDirInputToOut;

        public CollectDirectoryInputTask(boolean isIncremental, @NotNull File directoryInput, @NotNull File traceClassDirectoryOutput, @NotNull Map<File, ? extends Status> mapOfChangedFiles, @NotNull Map<File, ? extends File> mapOfInputToOutput, @NotNull Map<File, File> resultOfDirInputToOut) {
            Intrinsics.checkNotNullParameter((Object)directoryInput, (String)"directoryInput");
            Intrinsics.checkNotNullParameter((Object)traceClassDirectoryOutput, (String)"traceClassDirectoryOutput");
            Intrinsics.checkNotNullParameter(mapOfChangedFiles, (String)"mapOfChangedFiles");
            Intrinsics.checkNotNullParameter(mapOfInputToOutput, (String)"mapOfInputToOutput");
            Intrinsics.checkNotNullParameter(resultOfDirInputToOut, (String)"resultOfDirInputToOut");
            this.isIncremental = isIncremental;
            this.directoryInput = directoryInput;
            this.traceClassDirectoryOutput = traceClassDirectoryOutput;
            this.mapOfChangedFiles = mapOfChangedFiles;
            this.mapOfInputToOutput = mapOfInputToOutput;
            this.resultOfDirInputToOut = resultOfDirInputToOut;
        }

        @Override
        public void run() {
            try {
                this.taskHandle();
            }
            catch (Throwable e) {
                Object[] objectArray = new Object[]{e.getMessage()};
                PluginLog.INSTANCE.printErrStackTrace(Trace.TAG, e, "[CollectDirectoryInputTask] task execute fail: %s", objectArray);
            }
        }

        private final void taskHandle() {
            File file;
            File input = this.directoryInput;
            if (this.mapOfInputToOutput.containsKey(input)) {
                File file2 = this.mapOfInputToOutput.get(input);
                Intrinsics.checkNotNull((Object)file2);
                file = file2;
            } else {
                file = new File(this.traceClassDirectoryOutput, input.getName());
            }
            File output = file;
            String inputFullPath = input.getAbsolutePath();
            String outputFullPath = output.getAbsolutePath();
            if (!output.exists()) {
                output.mkdirs();
            }
            if (!input.exists() && output.exists()) {
                if (output.isDirectory()) {
                    FileUtil.INSTANCE.deleteDir(output);
                } else {
                    FileUtil.INSTANCE.safeDeleteFile(output);
                }
            }
            if (this.isIncremental) {
                HashMap outChangedFiles = new HashMap();
                Map<File, Status> $this$forEach$iv = this.mapOfChangedFiles;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<File, Status>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<File, Status> element$iv;
                    Map.Entry<File, Status> entry = element$iv = iterator.next();
                    boolean bl = false;
                    File inputChangedFile = entry.getKey();
                    Status status = entry.getValue();
                    String changedFileInputFullPath = inputChangedFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)changedFileInputFullPath, (String)"changedFileInputFullPath");
                    CharSequence charSequence = changedFileInputFullPath;
                    Intrinsics.checkNotNullExpressionValue((Object)inputFullPath, (String)"inputFullPath");
                    if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)inputFullPath, (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)outputFullPath, (String)"outputFullPath");
                    File outputChangedFile = new File(StringsKt.replace$default((String)changedFileInputFullPath, (String)inputFullPath, (String)outputFullPath, (boolean)false, (int)4, null));
                    if (status == Status.ADDED || status == Status.CHANGED) {
                        this.resultOfDirInputToOut.put(inputChangedFile, outputChangedFile);
                    } else if (status == Status.REMOVED) {
                        outputChangedFile.delete();
                    }
                    ((Map)outChangedFiles).put(outputChangedFile, status);
                }
            } else {
                this.resultOfDirInputToOut.put(input, output);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/Trace$CollectJarInputTask;", "Ljava/lang/Runnable;", "inputJar", "Ljava/io/File;", "inputJarStatus", "Lcom/android/build/api/transform/Status;", "isIncremental", "", "uniqueOutputName", "traceClassFileOutput", "inputToOutput", "", "resultOfJarInputToOut", "", "(Ljava/io/File;Lcom/android/build/api/transform/Status;ZZLjava/io/File;Ljava/util/Map;Ljava/util/Map;)V", "run", "", "taskHandle", "apm-plugin"})
    public static final class CollectJarInputTask
    implements Runnable {
        @NotNull
        private final File inputJar;
        @NotNull
        private final Status inputJarStatus;
        private final boolean isIncremental;
        private final boolean uniqueOutputName;
        @NotNull
        private final File traceClassFileOutput;
        @NotNull
        private final Map<File, File> inputToOutput;
        @NotNull
        private final Map<File, File> resultOfJarInputToOut;

        public CollectJarInputTask(@NotNull File inputJar, @NotNull Status inputJarStatus, boolean isIncremental, boolean uniqueOutputName, @NotNull File traceClassFileOutput, @NotNull Map<File, ? extends File> inputToOutput, @NotNull Map<File, File> resultOfJarInputToOut) {
            Intrinsics.checkNotNullParameter((Object)inputJar, (String)"inputJar");
            Intrinsics.checkNotNullParameter((Object)inputJarStatus, (String)"inputJarStatus");
            Intrinsics.checkNotNullParameter((Object)traceClassFileOutput, (String)"traceClassFileOutput");
            Intrinsics.checkNotNullParameter(inputToOutput, (String)"inputToOutput");
            Intrinsics.checkNotNullParameter(resultOfJarInputToOut, (String)"resultOfJarInputToOut");
            this.inputJar = inputJar;
            this.inputJarStatus = inputJarStatus;
            this.isIncremental = isIncremental;
            this.uniqueOutputName = uniqueOutputName;
            this.traceClassFileOutput = traceClassFileOutput;
            this.inputToOutput = inputToOutput;
            this.resultOfJarInputToOut = resultOfJarInputToOut;
        }

        @Override
        public void run() {
            try {
                this.taskHandle();
            }
            catch (Throwable e) {
                PluginLog.printErrStackTrace$default(PluginLog.INSTANCE, Trace.TAG, e, null, new Object[0], 4, null);
            }
        }

        private final void taskHandle() {
            File file;
            File jarInput = this.inputJar;
            if (this.inputToOutput.containsKey(jarInput)) {
                File file2 = this.inputToOutput.get(jarInput);
                Intrinsics.checkNotNull((Object)file2);
                file = file2;
            } else {
                String outputJarName = this.uniqueOutputName ? com.cloud.apm.plugin.tasks.trace.Trace$Companion.appendSuffix$default(Companion, jarInput, null, 2, null) : Companion.appendSuffix(jarInput, "traced");
                file = new File(this.traceClassFileOutput, outputJarName);
            }
            File jarOutput = file;
            Object[] objectArray = new Object[]{jarInput, jarOutput};
            PluginLog.INSTANCE.debug(Trace.TAG, "CollectJarInputTask input %s -> output %s", objectArray);
            if (!this.isIncremental && jarOutput.exists()) {
                jarOutput.delete();
            }
            if (!jarOutput.getParentFile().exists()) {
                jarOutput.getParentFile().mkdirs();
            }
            if (!IOUtil.INSTANCE.isZipOrJar(jarInput)) {
                return;
            }
            if (this.isIncremental) {
                if (this.inputJarStatus == Status.ADDED || this.inputJarStatus == Status.CHANGED) {
                    this.resultOfJarInputToOut.put(jarInput, jarOutput);
                } else if (this.inputJarStatus == Status.REMOVED) {
                    jarOutput.delete();
                }
            } else {
                this.resultOfJarInputToOut.put(jarInput, jarOutput);
            }
        }
    }
}

