/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.cloud.apm.plugin.Const;
import com.cloud.apm.plugin.tasks.trace.Trace;
import com.cloud.apm.plugin.tasks.trace.TraceConfiguration;
import com.cloud.apm.plugin.tasks.trace.TraceUtils;
import com.cloud.apm.plugin.utils.APMPluginConfiguration;
import com.cloud.apm.plugin.utils.FileUtil;
import com.cloud.apm.plugin.utils.PluginLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0006\u0010\u0016\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\u0012\u0010\u001c\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u001e\u0018\u00010\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J \u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0010H\u0002J\u0010\u0010\u0004\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006("}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceTransform;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "transparent", "", "(Lorg/gradle/api/Project;Z)V", "variant", "", "getVariant", "()Ljava/lang/String;", "setVariant", "(Ljava/lang/String;)V", "configure", "Lcom/cloud/apm/plugin/tasks/trace/TraceConfiguration;", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "copyFileAndMkdirsAsNeed", "", "from", "Ljava/io/File;", "to", "disable", "enable", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "getScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "isIncremental", "toOutputFile", "outputDir", "inputDir", "inputFile", "transform", "transforming", "invocation", "Companion", "apm-plugin"})
public final class TraceTransform
extends Transform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private boolean transparent;
    @NotNull
    private String variant;
    @NotNull
    public static final String TAG = "TraceTransform";

    public TraceTransform(@NotNull Project project, boolean transparent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.transparent = transparent;
        this.variant = "";
    }

    public /* synthetic */ TraceTransform(Project project, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(project, bl);
    }

    @NotNull
    public final String getVariant() {
        return this.variant;
    }

    public final void setVariant(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.variant = string;
    }

    public final void enable() {
        this.transparent = false;
    }

    public final void disable() {
        this.transparent = true;
    }

    @NotNull
    public String getName() {
        return (String)Const.INSTANCE.getGetTaskName().invoke((Object)"Trace", (Object)StringsKt.capitalize((String)this.variant));
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"CONTENT_CLASS");
        return set;
    }

    @Nullable
    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        super.transform(transformInvocation);
        if (this.transparent) {
            this.transparent(transformInvocation);
        } else {
            this.transforming(transformInvocation);
        }
    }

    private final void transparent(TransformInvocation invocation) {
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        if (!invocation.isIncremental()) {
            TransformOutputProvider transformOutputProvider = outputProvider;
            if (transformOutputProvider != null) {
                transformOutputProvider.deleteAll();
            }
        }
        Collection collection = invocation.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"invocation.inputs");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TransformInput it = (TransformInput)element$iv;
            boolean bl = false;
            Collection collection2 = it.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"it.jarInputs");
            Iterable $this$forEach$iv2 = collection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JarInput jarInput = (JarInput)element$iv2;
                boolean bl2 = false;
                JarInput jarInput2 = jarInput;
                if (jarInput2 == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)jarInput2, (String)"jarInput");
                JarInput $this$transparent_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0 = jarInput;
                boolean bl3 = false;
                File inputJar = $this$transparent_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0.getFile();
                File outputJar = outputProvider.getContentLocation($this$transparent_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0.getName(), $this$transparent_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0.getContentTypes(), $this$transparent_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0.getScopes(), Format.JAR);
                if (invocation.isIncremental()) {
                    Status status = $this$transparent_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0.getStatus();
                    switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            Intrinsics.checkNotNullExpressionValue((Object)inputJar, (String)"inputJar");
                            Intrinsics.checkNotNullExpressionValue((Object)outputJar, (String)"outputJar");
                            this.copyFileAndMkdirsAsNeed(inputJar, outputJar);
                            break;
                        }
                        case 4: {
                            FileUtil.INSTANCE.safeDeleteFile(outputJar);
                        }
                    }
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)inputJar, (String)"inputJar");
                Intrinsics.checkNotNullExpressionValue((Object)outputJar, (String)"outputJar");
                this.copyFileAndMkdirsAsNeed(inputJar, outputJar);
            }
            Collection collection3 = it.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"it.directoryInputs");
            $this$forEach$iv2 = collection3;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                boolean $i$f$forEach3;
                Iterable $this$forEach$iv3;
                DirectoryInput directoryInput = (DirectoryInput)element$iv2;
                boolean bl4 = false;
                DirectoryInput directoryInput2 = directoryInput;
                if (directoryInput2 == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)directoryInput2, (String)"directoryInput");
                DirectoryInput $this$transparent_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4 = directoryInput;
                boolean bl5 = false;
                File inputDir = $this$transparent_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.getFile();
                File outputDir = outputProvider.getContentLocation($this$transparent_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.getName(), $this$transparent_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.getContentTypes(), $this$transparent_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.getScopes(), Format.DIRECTORY);
                if (invocation.isIncremental()) {
                    $this$forEach$iv3 = directoryInput.getChangedFiles().entrySet();
                    $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        Map.Entry entry = (Map.Entry)element$iv3;
                        boolean bl6 = false;
                        Status status = (Status)entry.getValue();
                        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 3: {
                                if (((File)entry.getKey()).isDirectory()) break;
                                Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
                                Intrinsics.checkNotNullExpressionValue((Object)inputDir, (String)"inputDir");
                                Object k = entry.getKey();
                                Intrinsics.checkNotNullExpressionValue(k, (String)"entry.key");
                                File outputFile = this.toOutputFile(outputDir, inputDir, (File)k);
                                Object k2 = entry.getKey();
                                Intrinsics.checkNotNullExpressionValue(k2, (String)"entry.key");
                                this.copyFileAndMkdirsAsNeed((File)k2, outputFile);
                                break;
                            }
                            case 4: {
                                Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
                                Intrinsics.checkNotNullExpressionValue((Object)inputDir, (String)"inputDir");
                                Object k = entry.getKey();
                                Intrinsics.checkNotNullExpressionValue(k, (String)"entry.key");
                                File outputFile = this.toOutputFile(outputDir, inputDir, (File)k);
                                FileUtil.INSTANCE.deleteIfExists(outputFile);
                            }
                        }
                    }
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)inputDir, (String)"inputDir");
                $this$forEach$iv3 = FileUtil.INSTANCE.getAllFiles(inputDir);
                $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    File file = (File)element$iv3;
                    boolean bl7 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
                    File out = this.toOutputFile(outputDir, inputDir, file);
                    this.copyFileAndMkdirsAsNeed(file, out);
                }
            }
        }
    }

    private final void copyFileAndMkdirsAsNeed(File from, File to) {
        if (from.exists()) {
            to.getParentFile().mkdirs();
            FileUtil.INSTANCE.copyFile(from, to);
        }
    }

    private final File toOutputFile(File outputDir, File inputDir, File inputFile) {
        return new File(outputDir, FilesKt.toRelativeString((File)inputFile, (File)inputDir));
    }

    private final TraceConfiguration configure(TransformInvocation transformInvocation) {
        String buildDir = this.project.getBuildDir().getAbsolutePath();
        String dirName = transformInvocation.getContext().getVariantName();
        String string = this.project.getBuildDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.buildDir.absolutePath");
        Intrinsics.checkNotNullExpressionValue((Object)dirName, (String)"dirName");
        String mappingOut = TraceUtils.INSTANCE.getTraceMappingOut(string, dirName);
        PluginLog.INSTANCE.info("TraceFile", "mappingOut dir is: " + mappingOut, new Object[0]);
        return new TraceConfiguration.Builder().setMethodMapFilePath(mappingOut + "/methodMapping.txt").setIgnoreMethodMapFilePath(mappingOut + "/ignoreMethodMapping.txt").setBlockListFile(APMPluginConfiguration.Companion.getInstance().getTrace().getBlockListFilePath()).setMappingPath(mappingOut).setSkipCheckClass(true).build();
    }

    private final void transforming(TransformInvocation invocation) {
        long start = System.currentTimeMillis();
        TransformOutputProvider transformOutputProvider = invocation.getOutputProvider();
        Intrinsics.checkNotNull((Object)transformOutputProvider);
        TransformOutputProvider outputProvider = transformOutputProvider;
        boolean isIncremental = invocation.isIncremental() && this.isIncremental();
        TraceConfiguration config = this.configure(invocation);
        ArrayList<File> inputFiles = new ArrayList<File>();
        ConcurrentHashMap changedFiles = new ConcurrentHashMap();
        ConcurrentHashMap<File, File> inputToOutput = new ConcurrentHashMap<File, File>();
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        Ref.ObjectRef transformDirectory = new Ref.ObjectRef();
        Function3 handlerBlock2 = (Function3)new Function3<File, Format, QualifiedContent, Unit>(inputFiles, outputProvider, inputToOutput, (Ref.ObjectRef<File>)transformDirectory){
            final /* synthetic */ ArrayList<File> $inputFiles;
            final /* synthetic */ TransformOutputProvider $outputProvider;
            final /* synthetic */ ConcurrentHashMap<File, File> $inputToOutput;
            final /* synthetic */ Ref.ObjectRef<File> $transformDirectory;
            {
                this.$inputFiles = $inputFiles;
                this.$outputProvider = $outputProvider;
                this.$inputToOutput = $inputToOutput;
                this.$transformDirectory = $transformDirectory;
                super(3);
            }

            public final void invoke(@NotNull File key, @NotNull Format format, @NotNull QualifiedContent content) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                this.$inputFiles.add(key);
                File output = this.$outputProvider.getContentLocation(content.getName(), content.getContentTypes(), content.getScopes(), format);
                Map map = this.$inputToOutput;
                Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
                map.put(key, output);
                if (this.$transformDirectory.element == null) {
                    this.$transformDirectory.element = output.getParentFile();
                }
            }
        };
        Collection collection = invocation.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"invocation.inputs");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            TransformInput input = (TransformInput)element$iv;
            boolean bl = false;
            Collection collection2 = input.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"input.directoryInputs");
            Iterable $this$forEach$iv2 = collection2;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DirectoryInput directoryInput = (DirectoryInput)element$iv2;
                boolean bl2 = false;
                changedFiles.putAll(directoryInput.getChangedFiles());
                File inputDir = directoryInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)inputDir, (String)"inputDir");
                Intrinsics.checkNotNullExpressionValue((Object)directoryInput, (String)"directoryInput");
                handlerBlock2.invoke((Object)inputDir, (Object)Format.DIRECTORY, (Object)directoryInput);
            }
            Collection collection3 = input.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"input.jarInputs");
            $this$forEach$iv2 = collection3;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Status status;
                JarInput jarInput = (JarInput)element$iv2;
                boolean bl3 = false;
                File inputFile = jarInput.getFile();
                Map map = changedFiles;
                Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
                File file = inputFile;
                Intrinsics.checkNotNullExpressionValue((Object)jarInput.getStatus(), (String)"jarInput.status");
                map.put(file, status);
                Intrinsics.checkNotNullExpressionValue((Object)jarInput, (String)"jarInput");
                handlerBlock2.invoke((Object)inputFile, (Object)Format.JAR, (Object)jarInput);
            }
        }
        if (inputFiles.size() == 0 || transformDirectory.element == null) {
            PluginLog.INSTANCE.info(TAG, "trace do not find any input files", new Object[0]);
            return;
        }
        Object object = transformDirectory.element;
        Intrinsics.checkNotNull((Object)object);
        File outputDirectory = (File)object;
        String string = config.getBaseMethodMapPath();
        String string2 = config.getBlockListFilePath();
        String string3 = config.getMappingDir();
        String string4 = config.getIgnoreMethodMapFilePath();
        String string5 = config.getMethodMapFilePath();
        Project project = this.project;
        Trace $i$f$forEach22 = new Trace(project, string3, string5, string, string2, string4);
        boolean bl = config.getSkipCheckClass();
        Trace.doTransform$default($i$f$forEach22, isIncremental, bl, true, inputFiles, changedFiles, inputToOutput, outputDirectory, null, 128, null);
        long cost = System.currentTimeMillis() - start;
        PluginLog.INSTANCE.info(TAG, " Insert trace instrumentations cost time: " + cost + " ms.", new Object[0]);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/TraceTransform$Companion;", "", "()V", "TAG", "", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            nArray[Status.NOTCHANGED.ordinal()] = 1;
            nArray[Status.ADDED.ordinal()] = 2;
            nArray[Status.CHANGED.ordinal()] = 3;
            nArray[Status.REMOVED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

