/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace.methodTrace;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.TestedExtension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a8\u0006\u000b"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/TraceClassLoader;", "", "()V", "getAndroidJar", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "getClassLoader", "Ljava/net/URLClassLoader;", "inputFiles", "", "apm-plugin"})
public final class TraceClassLoader {
    @NotNull
    public static final TraceClassLoader INSTANCE = new TraceClassLoader();

    private TraceClassLoader() {
    }

    @NotNull
    public final URLClassLoader getClassLoader(@NotNull Project project, @NotNull Collection<? extends File> inputFiles) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(inputFiles, (String)"inputFiles");
        ArrayList<URL> urls = new ArrayList<URL>();
        File androidJar = this.getAndroidJar(project);
        if (androidJar != null) {
            urls.add(androidJar.toURI().toURL());
        }
        for (File file : inputFiles) {
            urls.add(file.toURI().toURL());
        }
        ArrayList<URL> urlImmutableList = urls;
        Collection $this$toTypedArray$iv = urlImmutableList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        URL[] uRLArray2 = uRLArray;
        return new URLClassLoader(uRLArray2);
    }

    private final File getAndroidJar(Project project) {
        TestedExtension extension;
        TestedExtension testedExtension = project.getPlugins().hasPlugin("com.android.application") ? (TestedExtension)project.getExtensions().findByType(AppExtension.class) : (extension = project.getPlugins().hasPlugin("com.android.library") ? (TestedExtension)project.getExtensions().findByType(LibraryExtension.class) : (TestedExtension)null);
        if (extension == null) {
            return null;
        }
        Object sdkDirectory = extension.getSdkDirectory().getAbsolutePath();
        String compileSdkVersion = extension.getCompileSdkVersion();
        String androidJarPath = (String)(sdkDirectory = (String)sdkDirectory + File.separator + "platforms" + File.separator) + compileSdkVersion + File.separator + "android.jar";
        File androidJar = new File(androidJarPath);
        return androidJar.exists() ? androidJar : (File)null;
    }
}

