/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.trace.methodTrace;

import com.cloud.apm.plugin.tasks.trace.mapping.MappingCollector;
import com.cloud.apm.plugin.tasks.trace.methodTrace.MethodInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u001d\u001a\u00020\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u001f\u001a\u00020\nJ\b\u0010 \u001a\u00020\u0004H\u0016J\u0010\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010%\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u0006\u0010&\u001a\u00020\nJ\b\u0010'\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\f\u00a8\u0006)"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/TraceMethod;", "", "()V", "accessFlag", "", "getAccessFlag", "()I", "setAccessFlag", "(I)V", "className", "", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "desc", "getDesc", "setDesc", "id", "getId", "setId", "isNativeMethod", "", "()Z", "methodName", "getMethodName", "setMethodName", "returnValue", "getReturnValue", "equals", "other", "getRealMethodName", "hashCode", "proguard", "", "processor", "Lcom/cloud/apm/plugin/tasks/trace/mapping/MappingCollector;", "revert", "toIgnoreString", "toString", "Companion", "apm-plugin"})
public final class TraceMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int id;
    private int accessFlag;
    public String className;
    public String methodName;
    @Nullable
    private String desc;
    @NotNull
    private static final String TAG = "TraceMethod";

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    public final int getAccessFlag() {
        return this.accessFlag;
    }

    public final void setAccessFlag(int n) {
        this.accessFlag = n;
    }

    @NotNull
    public final String getClassName() {
        String string = this.className;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
        return null;
    }

    public final void setClassName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.className = string;
    }

    @NotNull
    public final String getMethodName() {
        String string = this.methodName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"methodName");
        return null;
    }

    public final void setMethodName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.methodName = string;
    }

    @Nullable
    public final String getDesc() {
        return this.desc;
    }

    public final void setDesc(@Nullable String string) {
        this.desc = string;
    }

    @NotNull
    public final String getRealMethodName() {
        return this.desc == null || this.isNativeMethod() ? this.getClassName() + "." + this.getMethodName() : this.getClassName() + "." + this.getMethodName() + "." + this.desc;
    }

    public final void revert(@Nullable MappingCollector processor) {
        if (processor == null) {
            return;
        }
        String string = this.getClassName();
        String string2 = this.getMethodName();
        String string3 = this.desc;
        Intrinsics.checkNotNull((Object)string3);
        MethodInfo info = processor.originalMethodInfo(string, string2, string3);
        this.desc = info.getDesc();
        this.setMethodName(info.getOriginalName());
        this.setClassName(processor.originalClassName(this.getClassName(), this.getClassName()));
    }

    public final void proguard(@Nullable MappingCollector processor) {
        if (processor == null) {
            return;
        }
        String string = this.getClassName();
        String string2 = this.getMethodName();
        String string3 = this.desc;
        Intrinsics.checkNotNull((Object)string3);
        MethodInfo methodInfo = processor.obfuscatedMethodInfo(string, string2, string3);
        this.setMethodName(methodInfo.getOriginalName());
        this.desc = methodInfo.getDesc();
        this.setClassName(processor.proguardClassName(this.getClassName(), this.getClassName()));
    }

    @Nullable
    public final String getReturnValue() {
        CharSequence charSequence = this.desc;
        return charSequence == null || charSequence.length() == 0 ? null : Type.getReturnType((String)this.desc).toString();
    }

    @NotNull
    public String toString() {
        return this.desc == null || this.isNativeMethod() ? this.id + "," + this.accessFlag + "," + this.getClassName() + " " + this.getMethodName() : this.id + "," + this.accessFlag + "," + this.getClassName() + " " + this.getMethodName() + " " + this.desc;
    }

    @NotNull
    public final String toIgnoreString() {
        return this.desc == null || this.isNativeMethod() ? this.getClassName() + " " + this.getMethodName() : this.getClassName() + " " + this.getMethodName() + " " + this.desc;
    }

    private final boolean isNativeMethod() {
        return (this.accessFlag & 0x100) != 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof TraceMethod ? Intrinsics.areEqual((Object)((TraceMethod)other).getRealMethodName(), (Object)this.getRealMethodName()) : false;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.accessFlag;
        result = 31 * result + this.getClassName().hashCode();
        result = 31 * result + this.getMethodName().hashCode();
        String string = this.desc;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/cloud/apm/plugin/tasks/trace/methodTrace/TraceMethod$Companion;", "", "()V", "TAG", "", "create", "Lcom/cloud/apm/plugin/tasks/trace/methodTrace/TraceMethod;", "id", "", "accessFlag", "className", "methodName", "desc", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TraceMethod create(int id, int accessFlag, @NotNull String className, @NotNull String methodName, @NotNull String desc) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            TraceMethod traceMethod = new TraceMethod();
            traceMethod.setId(id);
            traceMethod.setAccessFlag(accessFlag);
            traceMethod.setClassName(StringsKt.replace$default((String)className, (String)"/", (String)".", (boolean)false, (int)4, null));
            traceMethod.setMethodName(methodName);
            traceMethod.setDesc(StringsKt.replace$default((String)desc, (String)"/", (String)".", (boolean)false, (int)4, null));
            return traceMethod;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

