/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.tasks.traffic.transformer;

import com.cloud.apm.plugin.transform.ITransformContext;
import com.cloud.apm.plugin.transform.transformer.AbsTransformer;
import com.cloud.apm.plugin.transform.transformer.AbsTransformerKt;
import com.cloud.apm.plugin.utils.APMPluginConfiguration;
import com.cloud.apm.plugin.utils.FileUtilKt;
import com.cloud.apm.plugin.utils.PluginLog;
import com.cloud.apm.plugin.utils.TransformUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/cloud/apm/plugin/tasks/traffic/transformer/UrlConnectionTransformer;", "Lcom/cloud/apm/plugin/transform/transformer/AbsTransformer;", "()V", "connectionProxyClass", "", "connectionProxyDESC", "connectionProxyMethod", "transform", "Lorg/objectweb/asm/tree/ClassNode;", "project", "Lorg/gradle/api/Project;", "apmPluginConfiguration", "Lcom/cloud/apm/plugin/utils/APMPluginConfiguration;", "context", "Lcom/cloud/apm/plugin/transform/ITransformContext;", "klass", "Companion", "apm-plugin"})
public final class UrlConnectionTransformer
extends AbsTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String connectionProxyClass;
    @NotNull
    private final String connectionProxyMethod;
    @NotNull
    private final String connectionProxyDESC;
    @NotNull
    private static final String TAG = "UrlConnectionTransformer";

    public UrlConnectionTransformer() {
        this.connectionProxyClass = "com/cloud/apm/services/network/http/urlconnection/URLConnectionHook";
        this.connectionProxyMethod = "proxy";
        this.connectionProxyDESC = "(Ljava/net/URLConnection;)Ljava/net/URLConnection;";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ClassNode transform(@Nullable Project project, @NotNull APMPluginConfiguration apmPluginConfiguration, @NotNull ITransformContext context2, @NotNull ClassNode klass) {
        Intrinsics.checkNotNullParameter((Object)apmPluginConfiguration, (String)"apmPluginConfiguration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        String className = AbsTransformerKt.getClassName(klass);
        if (!apmPluginConfiguration.getNetworkEnable() || !apmPluginConfiguration.getNetwork().getUrlConnect()) {
            return klass;
        }
        List list = klass.methods;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"klass.methods");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            List list2;
            Iterable iterable;
            ListIterator listIterator;
            MethodNode method = (MethodNode)element$iv;
            boolean bl = false;
            InsnList insnList = method.instructions;
            if (insnList == null || (listIterator = insnList.iterator()) == null || (iterable = TransformUtilKt.asIterable(listIterator)) == null || (list2 = CollectionsKt.filterIsInstance(iterable, MethodInsnNode.class)) == null) continue;
            Iterable iterable2 = list2;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MethodInsnNode it = (MethodInsnNode)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = it.getOpcode() == 182 && Intrinsics.areEqual((Object)it.owner, (Object)"java/net/URL") && Intrinsics.areEqual((Object)it.name, (Object)"openConnection") && Intrinsics.areEqual((Object)it.desc, (Object)"()Ljava/net/URLConnection;");
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MethodInsnNode it = (MethodInsnNode)element$iv2;
                boolean bl4 = false;
                PluginLog.INSTANCE.debug(TAG, FileUtilKt.lastPath(context2.getProjectDir()) + "->hook URL#openConnection method  succeed in : " + className + "_" + method.name + "_" + method.desc, new Object[0]);
                method.instructions.insert((AbstractInsnNode)it, (AbstractInsnNode)new MethodInsnNode(184, this.connectionProxyClass, this.connectionProxyMethod, this.connectionProxyDESC, false));
            }
        }
        return klass;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cloud/apm/plugin/tasks/traffic/transformer/UrlConnectionTransformer$Companion;", "", "()V", "TAG", "", "apm-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

