/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.apm.plugin.transform.transformer;

import com.cloud.apm.plugin.transform.APMTransformContext;
import com.cloud.apm.plugin.transform.ITransformContext;
import com.cloud.apm.plugin.transform.transformer.AbsTransformerKt;
import com.cloud.apm.plugin.transform.transformer.ClassTransformer;
import com.cloud.apm.plugin.utils.APMPluginConfiguration;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/cloud/apm/plugin/transform/transformer/AbsTransformer;", "Lcom/cloud/apm/plugin/transform/transformer/ClassTransformer;", "()V", "onInterceptor", "", "context", "Lcom/cloud/apm/plugin/transform/ITransformContext;", "klass", "Lorg/objectweb/asm/tree/ClassNode;", "transform", "project", "Lorg/gradle/api/Project;", "apmPluginConfiguration", "Lcom/cloud/apm/plugin/utils/APMPluginConfiguration;", "apm-plugin"})
public class AbsTransformer
implements ClassTransformer {
    public boolean onInterceptor(@NotNull ITransformContext context2, @NotNull ClassNode klass) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!APMPluginConfiguration.Companion.getInstance().getPluginEnable()) {
            return true;
        }
        return Intrinsics.areEqual((Object)AbsTransformerKt.getClassName(klass), (Object)"module-info");
    }

    @Override
    @NotNull
    public ClassNode transform(@NotNull ITransformContext context2, @NotNull ClassNode klass) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (this.onInterceptor(context2, klass)) {
            return klass;
        }
        if (APMPluginConfiguration.Companion.getInstance().ignorePackageNames(AbsTransformerKt.getClassName(klass))) {
            return klass;
        }
        if (context2 instanceof APMTransformContext) {
            Project project = ((APMTransformContext)context2).project();
            APMPluginConfiguration configuration = ((APMTransformContext)context2).configuration();
            this.transform(project, configuration, context2, klass);
        }
        return klass;
    }

    @NotNull
    public ClassNode transform(@Nullable Project project, @NotNull APMPluginConfiguration apmPluginConfiguration, @NotNull ITransformContext context2, @NotNull ClassNode klass) {
        Intrinsics.checkNotNullParameter((Object)apmPluginConfiguration, (String)"apmPluginConfiguration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return klass;
    }

    @Override
    @NotNull
    public String getName() {
        return ClassTransformer.DefaultImpls.getName(this);
    }

    @Override
    @NotNull
    public File reportDir(@NotNull ITransformContext context2) {
        return ClassTransformer.DefaultImpls.reportDir(this, context2);
    }

    @Override
    @NotNull
    public File getReport(@NotNull ITransformContext context2, @NotNull String name) {
        return ClassTransformer.DefaultImpls.getReport(this, context2, name);
    }

    @Override
    public void onPreDoTransform(@NotNull ITransformContext context2) {
        ClassTransformer.DefaultImpls.onPreDoTransform(this, context2);
    }

    @Override
    public void onPostDoTransform(@NotNull ITransformContext context2) {
        ClassTransformer.DefaultImpls.onPostDoTransform(this, context2);
    }
}

